/*
 * Decompiled with CFR 0.152.
 */
package me.dcatcher.demonology.util;

import java.util.List;
import me.dcatcher.demonology.item.ItemSoulFlask;
import me.dcatcher.demonology.util.DefaultSoulHandler;
import me.dcatcher.demonology.util.ISoulHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Ritual {
    public String name;
    public String[] ritualLayout;
    public int level;
    public int soulCost;

    public Ritual(String name, String[] recipe, int level, int soulCost) {
        this.name = name;
        this.ritualLayout = recipe;
        this.level = level;
        this.soulCost = soulCost;
    }

    public ISoulHandler canComplete(World world, BlockPos centre) {
        int l = this.ritualLayout[0].length();
        if (l != this.ritualLayout.length) {
            return null;
        }
        List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(centre.func_177982_a(-3, -3, -3), centre.func_177982_a(3, 3, 3)));
        if (items.size() == 0) {
            return null;
        }
        boolean willExecute = false;
        ISoulHandler ish = null;
        for (EntityItem item : items) {
            if (!(item.func_92059_d().func_77973_b() instanceof ItemSoulFlask) || (ish = DefaultSoulHandler.getHandler(item.func_92059_d())) == null) continue;
            willExecute = ish.getSouls() >= this.soulCost;
        }
        if (!willExecute) {
            return null;
        }
        for (int x = 0; x < this.ritualLayout.length; ++x) {
            for (int z = 0; z < l; ++z) {
                Block actual;
                Block shouldBe = Ritual.getBlockFromChar(this.ritualLayout[x].charAt(z));
                if (shouldBe == null || (actual = world.func_180495_p(centre.func_177982_a(x - 1, 0, z - 1)).func_177230_c()) == shouldBe) continue;
                return null;
            }
        }
        return ish;
    }

    public void destroyBlocks(World world, BlockPos centre) {
        int l = this.ritualLayout[0].length();
        for (int x = 0; x < this.ritualLayout.length; ++x) {
            for (int z = 0; z < l; ++z) {
                Block shouldBe = Ritual.getBlockFromChar(this.ritualLayout[x].charAt(z));
                if (shouldBe == null) continue;
                BlockPos pos = centre.func_177982_a(x - 1, 0, z - 1);
                world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, true);
                world.func_175698_g(pos);
            }
        }
    }

    public static Block getBlockFromChar(char c) {
        switch (c) {
            case 'd': {
                return Block.func_149684_b((String)"diamond_block");
            }
            case 'r': {
                return null;
            }
            case 'R': {
                return Block.func_149684_b((String)"redstone_block");
            }
        }
        return null;
    }
}

