/*
 * Decompiled with CFR 0.152.
 */
package me.dcatcher.demonology.entities;

import java.util.Random;
import javax.annotation.Nullable;
import me.dcatcher.demonology.entities.EntityPulse;
import me.dcatcher.demonology.entities.IDemon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;

public class EntityDemonicEye
extends EntityFlying
implements IMob,
IRangedAttackMob,
IDemon {
    public BlockPos posStart;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityDemonicEye(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 3.0f);
        this.field_70728_aV = 5;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_70606_j(this.func_110138_aP());
        this.field_70765_h = new DemonicEyeMoveHelper(this);
    }

    public EntityDemonicEye(World w, float x, float y, float z) {
        this(w);
        this.posStart = new BlockPos((double)x, (double)y, (double)z);
        this.func_70107_b(x, y, z);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("demonology", "loot_demonic_eye");
    }

    public void addPlayerToInfo(EntityPlayerMP player) {
        this.bossInfo.func_186760_a(player);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.bossInfo.func_186758_d(false);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1024, new BlockPos((Entity)this), 0);
        for (int i = 0; i < 9; ++i) {
            int xModifier = i % 3 - 1;
            int zModifier = Math.floorDiv(i, 3);
            double d0 = this.field_70165_t + (double)xModifier;
            double d1 = this.field_70163_u;
            double d2 = this.field_70161_v + (double)zModifier;
            double d3 = target.field_70165_t - d0;
            double d4 = target.field_70163_u - d1;
            double d5 = target.field_70161_v - d2;
            Vec3d accel = new Vec3d(d3, d4, d5);
            accel = accel.func_72432_b();
            EntityPulse entityP = new EntityPulse(this.field_70170_p, this.field_70165_t + accel.field_72450_a, this.field_70163_u + accel.field_72448_b, this.field_70161_v + accel.field_72449_c, d3, d4, d5);
            this.field_70170_p.func_72838_d((Entity)entityP);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityDemonicEye parentEntity;

        public AILookAround(EntityDemonicEye demonicEye) {
            this.parentEntity = demonicEye;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class DemonicEyeMoveHelper
    extends EntityMoveHelper {
        private final EntityDemonicEye parentEntity;
        private int courseChangeCooldown;

        public DemonicEyeMoveHelper(EntityDemonicEye demonicEye) {
            super((EntityLiving)demonicEye);
            this.parentEntity = demonicEye;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityDemonicEye parentEntity;

        public AIRandomFly(EntityDemonicEye demonicEye) {
            this.parentEntity = demonicEye;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (this.parentEntity.posStart != null) {
                d0 = Math.min(d0, (double)(this.parentEntity.posStart.func_177958_n() + 20));
                d0 = Math.max(d0, (double)(this.parentEntity.posStart.func_177958_n() - 20));
                d1 = Math.min(d1, (double)(this.parentEntity.posStart.func_177956_o() + 10));
                d1 = Math.max(d1, (double)(this.parentEntity.posStart.func_177956_o() - 10));
                d2 = Math.min(d2, (double)(this.parentEntity.posStart.func_177952_p() + 20));
                d2 = Math.max(d2, (double)(this.parentEntity.posStart.func_177952_p() - 20));
            }
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 0.5);
        }
    }
}

