/*
 * Decompiled with CFR 0.152.
 */
package me.dcatcher.demonology.block;

import javax.annotation.Nullable;
import me.dcatcher.demonology.Demonology;
import me.dcatcher.demonology.block.BlockTileEntity;
import me.dcatcher.demonology.item.ItemSoulFlask;
import me.dcatcher.demonology.tileentities.TileEntityBasicAltar;
import me.dcatcher.demonology.util.AltarRecipe;
import me.dcatcher.demonology.util.DefaultSoulHandler;
import me.dcatcher.demonology.util.ISoulHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBasicAltar
extends BlockTileEntity<TileEntityBasicAltar> {
    public BlockBasicAltar(Material blockMaterialIn, String name) {
        super(blockMaterialIn, name);
        this.func_149711_c(1.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityBasicAltar te = (TileEntityBasicAltar)((Object)this.getTileEntity((IBlockAccess)world, pos));
            if (player.field_71071_by.func_70448_g() == ItemStack.field_190927_a || player.field_71071_by.func_70448_g().func_77973_b() == Item.func_111206_d((String)"air") || player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSoulFlask) {
                this.doCrafting(te, player, world, pos);
            } else if (te.itemCount < 6) {
                ItemStack removed = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                te.iStackHandler.setStackInSlot(te.itemCount++, removed);
            } else {
                this.dropAllItems(world, pos);
            }
            te.func_70296_d();
        }
        return true;
    }

    public void punishPlayer(EntityPlayer player) {
        player.func_70606_j(2.0f);
        player.func_70097_a(DamageSource.field_76377_j, 1.0f);
        if (player.func_71024_bL().func_75116_a() > 15) {
            player.func_71024_bL().func_75114_a(15);
        }
    }

    public void doCrafting(TileEntityBasicAltar te, EntityPlayer player, World world, BlockPos pos) {
        Item[] contents = te.getContents();
        ItemStack st = null;
        boolean crafting = false;
        for (AltarRecipe recipe : Demonology.altarRecipes) {
            if (!recipe.checkRecipe(contents)) continue;
            st = new ItemStack(recipe.output, recipe.count);
            crafting = true;
            break;
        }
        if (!crafting) {
            this.dropAllItems(world, pos);
        } else {
            if (player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSoulFlask) {
                ISoulHandler ish = DefaultSoulHandler.getHandler(player.field_71071_by.func_70448_g());
                if (ish != null && ish.getSouls() > 10) {
                    ish.addSouls(-10);
                } else {
                    this.punishPlayer(player);
                }
            } else {
                this.punishPlayer(player);
            }
            te.startCrafting(st, world, 40);
            te.func_70296_d();
        }
    }

    private void dropAllItems(World world, BlockPos pos) {
        TileEntityBasicAltar te = (TileEntityBasicAltar)((Object)this.getTileEntity((IBlockAccess)world, pos));
        for (int i = 0; i < te.itemCount; ++i) {
            ItemStack is = te.iStackHandler.getStackInSlot(i);
            EntityItem toDrop = new EntityItem(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), is);
            world.func_72838_d((Entity)toDrop);
        }
        te.clear();
    }

    @Override
    public Class getTileEntityClass() {
        return TileEntityBasicAltar.class;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBasicAltar();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropAllItems(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

