/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.yastm.world;

import com.unrealdinnerbone.yastm.lib.DimBlockPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class YatmWorldSaveData
extends WorldSavedData {
    private static final String DATA_NAME = "yastm_TelerporterData";
    private HashMap<Integer, List<DimBlockPos>> postions = new HashMap();

    public YatmWorldSaveData() {
        super(DATA_NAME);
    }

    public YatmWorldSaveData(String s) {
        super(s);
    }

    public void addTelporter(int id, DimBlockPos blockPos) {
        if (blockPos != null) {
            if (!this.postions.containsKey(id) && id != 0) {
                this.postions.put(id, new ArrayList());
            }
            if (id != 0 && !this.postions.get(id).contains((Object)blockPos)) {
                this.postions.get(id).add(blockPos);
                System.out.println("Added DimBlockPos " + (Object)((Object)blockPos) + " with id" + id);
            }
        }
    }

    public List<DimBlockPos> getPostionsFormID(int id) {
        if (this.postions.containsKey(id) && id != 0) {
            return this.postions.get(id);
        }
        return new ArrayList<DimBlockPos>();
    }

    public int getIDFormPos(DimBlockPos pos) {
        for (int key : this.postions.keySet()) {
            for (DimBlockPos dimBlockPos : this.postions.get(key)) {
                if (!dimBlockPos.equals((Object)pos)) continue;
                return key;
            }
        }
        return 0;
    }

    public boolean hasTwin(DimBlockPos blockPos) {
        List<DimBlockPos> posList;
        int ID = this.getIDFormPos(blockPos);
        if (this.postions.containsKey(ID) && (posList = this.postions.get(ID)).size() == 2) {
            ArrayList<DimBlockPos> dummyList = new ArrayList<DimBlockPos>(posList);
            ArrayList<DimBlockPos> toRemove = new ArrayList<DimBlockPos>();
            for (DimBlockPos pos : posList) {
                if (!blockPos.equals((Object)pos)) continue;
                toRemove.add(pos);
            }
            dummyList.removeAll(toRemove);
            return dummyList.size() == 1;
        }
        return false;
    }

    public int removeDimBlockPos(DimBlockPos blockPos) {
        if (this.hasDimBlockPos(blockPos)) {
            for (int key : this.postions.keySet()) {
                List<DimBlockPos> posList = this.postions.get(key);
                if (!posList.contains((Object)blockPos)) continue;
                posList.remove((Object)blockPos);
                System.out.println("Removed DimBlockPos " + (Object)((Object)blockPos) + " form id" + key);
                return key;
            }
        }
        return 0;
    }

    public boolean hasDimBlockPos(DimBlockPos blockPos) {
        for (List<DimBlockPos> dimBlockPos : this.postions.values()) {
            for (DimBlockPos dimBlockPo : dimBlockPos) {
                if (!blockPos.equals((Object)dimBlockPo)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public DimBlockPos getTwin(DimBlockPos pos) {
        int id = this.getIDFormPos(pos);
        if (this.hasTwin(pos)) {
            ArrayList blockPosList = new ArrayList(this.postions.get(id));
            blockPosList.remove((Object)pos);
            return (DimBlockPos)((Object)blockPosList.stream().findFirst().get());
        }
        return null;
    }

    public void removePostionFormID(int id, DimBlockPos pos) {
        if (this.postions.containsKey(id)) {
            this.postions.get(id).remove((Object)pos);
        }
    }

    public static YatmWorldSaveData get(World world) {
        MapStorage storage = world.func_175693_T();
        YatmWorldSaveData instance = (YatmWorldSaveData)storage.func_75742_a(YatmWorldSaveData.class, DATA_NAME);
        if (instance == null) {
            instance = new YatmWorldSaveData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.postions = new HashMap();
        for (String key : nbt.func_150296_c()) {
            NBTTagCompound tagCompound;
            if (!key.startsWith("tpNumber_") || (tagCompound = nbt.func_74775_l(key)).func_150296_c().size() <= 0) continue;
            ArrayList<DimBlockPos> posList = new ArrayList<DimBlockPos>();
            for (String key2 : tagCompound.func_150296_c()) {
                String number = tagCompound.func_74779_i(key2);
                posList.add(DimBlockPos.formCompindThing(number));
            }
            String number = key.replace("tpNumber_", "");
            int x = Integer.parseInt(number);
            this.postions.put(x, posList);
        }
    }

    public void save(World world) {
        world.func_72823_a(DATA_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        for (int key : this.postions.keySet()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            int count = 0;
            for (DimBlockPos pos : this.postions.get(key)) {
                tagCompound.func_74778_a("" + count++, pos.func_177986_g() + ";" + pos.getDimID());
            }
            compound.func_74782_a("tpNumber_" + key, (NBTBase)tagCompound);
        }
        return compound;
    }
}

