/*
 * Decompiled with CFR 0.152.
 */
package com.vnator.adminshop.packets;

import com.vnator.adminshop.AdminShop;
import com.vnator.adminshop.blocks.shop.ShopItemStack;
import com.vnator.adminshop.blocks.shop.ShopStock;
import com.vnator.adminshop.capabilities.BalanceAdapter;
import com.vnator.adminshop.packets.PacketHandler;
import com.vnator.adminshop.packets.PacketUpdateMoney;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class PacketSendShopTransaction
implements IMessage {
    private short category;
    private int index;
    private int quantity;
    private boolean toBuy;

    public void fromBytes(ByteBuf buf) {
        this.category = buf.readShort();
        this.index = buf.readInt();
        this.quantity = buf.readInt();
        this.toBuy = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.category);
        buf.writeInt(this.index);
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.toBuy);
    }

    public PacketSendShopTransaction(short category, int index, int quantity, boolean toBuy) {
        this.category = category;
        this.index = index;
        this.quantity = quantity;
        this.toBuy = toBuy;
        System.out.println("Sending transaction IMessage! " + category + " , " + index + " , " + quantity + " , " + toBuy);
    }

    public PacketSendShopTransaction() {
    }

    public static class Handler
    implements IMessageHandler<PacketSendShopTransaction, IMessage> {
        public IMessage onMessage(PacketSendShopTransaction message, MessageContext ctx) {
            System.out.println("Received transaction message from client!");
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSendShopTransaction message, MessageContext ctx) {
            System.out.println("Handling transaction message!");
            float price = (message.toBuy ? ShopStock.buyItemPrices.get(message.category)[message.index] : ShopStock.sellItemPrices.get(message.category)[message.index]).floatValue();
            if (message.toBuy) {
                ItemStack transactionStack = ItemStack.field_190927_a;
                ItemStack tempItem = ShopStock.buyItems.get(message.category)[message.index];
                transactionStack = ItemHandlerHelper.copyStackWithSize((ItemStack)tempItem, (int)message.quantity);
                this.buyTransaction((EntityPlayer)ctx.getServerHandler().field_147369_b, transactionStack, price);
            } else {
                ShopItemStack stk = ShopStock.sellItems.get(message.category)[message.index];
                this.sellTransaction((EntityPlayer)ctx.getServerHandler().field_147369_b, stk, message.quantity, price);
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketUpdateMoney(BalanceAdapter.getMoneyServer(player)), player);
        }

        private void buyTransaction(EntityPlayer player, ItemStack toBuy, float price) {
            IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack returned = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)toBuy, (boolean)true);
            price = (float)(toBuy.func_190916_E() - returned.func_190916_E()) * price;
            boolean success = BalanceAdapter.withdraw(player, price);
            if (success) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)toBuy, (boolean)false);
            } else {
                AdminShop.logger.log(Level.ERROR, "Not enough money to perform transaction!");
            }
        }

        private void sellTransaction(EntityPlayer player, ItemStack toSell, float price) {
            IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            int numSold = this.removeItemsFromInventory(inventory, toSell);
            System.out.println("Removed " + numSold + " from inventory!");
            BalanceAdapter.deposit(player, price * (float)numSold);
        }

        private void sellTransaction(EntityPlayer player, ShopItemStack item, int quantity, float price) {
            IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            int numSold = this.removeItemsFromInventory(inventory, item, quantity);
            BalanceAdapter.deposit(player, price * (float)numSold);
        }

        private int removeItemsFromInventory(IItemHandler inv, ItemStack item) {
            int count = item.func_190916_E();
            System.out.println("Removing items from inventory! # to remove: " + count);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack comp = inv.getStackInSlot(i);
                if (!this.itemstacksEqual(comp, item)) continue;
                if (count > comp.func_190916_E()) {
                    count -= comp.func_190916_E();
                    inv.extractItem(i, comp.func_190916_E(), false);
                    continue;
                }
                inv.extractItem(i, count, false);
                return item.func_190916_E();
            }
            return item.func_190916_E() - count;
        }

        private int removeItemsFromInventory(IItemHandler inv, ShopItemStack item, int quantity) {
            int count = quantity;
            System.out.println("Removing items from inventory! # to remove: " + count);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack comp = inv.getStackInSlot(i);
                if (!item.itemEqual(comp)) continue;
                if (count > comp.func_190916_E()) {
                    count -= comp.func_190916_E();
                    inv.extractItem(i, comp.func_190916_E(), false);
                    continue;
                }
                inv.extractItem(i, count, false);
                return quantity;
            }
            return quantity - count;
        }

        private boolean itemstacksEqual(ItemStack a, ItemStack b) {
            if (a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j()) {
                NBTTagCompound atag = a.func_77978_p();
                NBTTagCompound btag = b.func_77978_p();
                if (atag == null && btag == null) {
                    return true;
                }
                if (atag != btag && atag != null && a.func_77978_p().equals((Object)b.func_77978_p())) {
                    return true;
                }
            }
            return false;
        }
    }
}

