/*
 * Decompiled with CFR 0.152.
 */
package com.vnator.adminshop.capabilities.money;

import com.vnator.adminshop.capabilities.money.IMoney;

public class Money
implements IMoney {
    private float money = 100.0f;
    private String moneyFormatted = "$100.00";

    private void formatMoney() {
        this.moneyFormatted = this.money < 1000000.0f ? "$" + String.format("%.2f", Float.valueOf(this.money)) : (this.money < 1.0E9f ? "$" + this.money / 1000000.0f + " M" : "$" + this.money / 1.0E9f + " B");
    }

    @Override
    public boolean deposit(float amt) {
        if (amt < 0.0f) {
            System.err.println("Error: Attempting to deposit value < 0!");
            return false;
        }
        this.money += amt;
        this.formatMoney();
        return true;
    }

    @Override
    public boolean withdraw(float amt) {
        if (this.canPerformWithdraw(amt)) {
            System.out.println("\n\nWithdrawing Money!!!\nAt $" + this.money + "\n\n");
            this.money -= amt;
            this.formatMoney();
            return true;
        }
        return false;
    }

    @Override
    public boolean canPerformWithdraw(float amt) {
        return this.money >= amt && amt >= 0.0f;
    }

    @Override
    public float getMoney() {
        return this.money;
    }

    @Override
    public String getFormattedMoney() {
        return this.moneyFormatted;
    }

    @Override
    public void setMoney(float amt) {
        this.money = amt;
        this.formatMoney();
    }
}

