/*
 * Decompiled with CFR 0.152.
 */
package com.vnator.adminshop.capabilities.ledger;

import com.vnator.adminshop.AdminShop;
import com.vnator.adminshop.ConfigHandler;
import com.vnator.adminshop.capabilities.ledger.ILedger;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class Ledger
implements ILedger {
    private HashMap<String, Float> balances = new HashMap();

    @Override
    public boolean deposit(String username, float amount) {
        if (amount < 0.0f) {
            AdminShop.logger.log(Level.ERROR, "Trying to deposit value less than 0 into ledger!");
            return false;
        }
        this.addPlayer(username);
        this.balances.put(username, Float.valueOf(this.balances.get(username).floatValue() + amount));
        return true;
    }

    @Override
    public boolean withdraw(String username, float amount) {
        if (!this.canPerformWithdraw(username, amount)) {
            return false;
        }
        this.balances.put(username, Float.valueOf(this.balances.get(username).floatValue() - amount));
        return true;
    }

    @Override
    public boolean canPerformWithdraw(String username, float money) {
        return this.balances.get(username).floatValue() >= money;
    }

    @Override
    public float getMoney(String username) {
        if (this.balances == null || username == null) {
            return 0.0f;
        }
        if (!this.balances.containsKey(username)) {
            this.addPlayer(username);
        }
        return this.balances.get(username).floatValue();
    }

    @Override
    public void setMoney(String username, float money) {
        this.balances.put(username, Float.valueOf(money));
    }

    @Override
    public void addPlayer(String username) {
        if (!this.balances.containsKey(username)) {
            this.balances.put(username, Float.valueOf(ConfigHandler.GENERAL_CONFIGS.startingMoney));
        }
    }

    @Override
    public HashMap<String, Float> getMap() {
        return this.balances;
    }

    @Override
    public void loadFromNBT(NBTTagCompound tag) {
        this.balances = new HashMap(tag.func_150296_c().size());
        for (String key : tag.func_150296_c()) {
            this.balances.put(key, Float.valueOf(tag.func_74760_g(key)));
        }
    }
}

