/*
 * Decompiled with CFR 0.152.
 */
package com.vnator.adminshop.blocks.shop;

import com.vnator.adminshop.AdminShop;
import com.vnator.adminshop.blocks.shop.ShopItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class ShopStock {
    public static ArrayList<ItemStack[]> buyItems;
    public static ArrayList<Float[]> buyItemPrices;
    public static ArrayList<ShopItemStack[]> sellItems;
    public static ArrayList<Float[]> sellItemPrices;
    public static String[] buyCategories;
    public static String[] sellCategories;
    public static FluidStack[] buyFluids;
    public static float[] buyFluidPrices;
    public static HashMap<String, Float> sellItemMap;
    public static HashMap<String, Float> sellFluidMap;
    public static HashMap<Integer, Float> sellItemOredictMap;

    public static void setShopCategories(String[] buyCats, String[] sellCats) {
        buyCategories = buyCats.length != 0 ? buyCats : new String[]{"Items"};
        sellCategories = sellCats.length != 0 ? sellCats : new String[]{"Items"};
    }

    public static void setShopStockBuy(ArrayList<String[]> itemNames, ArrayList<Float[]> itemPrices) {
        buyItems = new ArrayList();
        buyItemPrices = itemPrices;
        for (int i = 0; i < itemNames.size(); ++i) {
            buyItems.add(new ItemStack[itemNames.get(i).length]);
            for (int j = 0; j < itemNames.get(i).length; ++j) {
                ItemStack item = ShopStock.parseItemString(itemNames.get(i)[j]);
                if (item == null) {
                    AdminShop.logger.log(Level.ERROR, "OreDict entry used for buy list. Incompatible!");
                    item = ItemStack.field_190927_a;
                }
                ShopStock.buyItems.get((int)i)[j] = item;
            }
        }
    }

    public static void setShopStockSell(ArrayList<String[]> itemNames, ArrayList<Float[]> itemPrices) {
        sellItems = new ArrayList();
        sellItemPrices = itemPrices;
        for (int i = 0; i < itemNames.size(); ++i) {
            sellItems.add(new ShopItemStack[itemNames.get(i).length]);
            for (int j = 0; j < itemNames.get(i).length; ++j) {
                String myname;
                String itemName = itemNames.get(i)[j];
                ItemStack tempItem = ShopStock.parseItemString(itemName);
                ShopStock.sellItems.get((int)i)[j] = tempItem == null ? ShopStock.parseOredict(itemName) : new ShopItemStack(tempItem);
                AdminShop.logger.log(Level.INFO, "Sellable item: " + itemName);
                if (sellItems.get(i)[j].isOreDict()) {
                    myname = "ore:" + sellItems.get(i)[j].getOreName();
                    sellItemOredictMap.put(OreDictionary.getOreID((String)sellItems.get(i)[j].getOreName()), sellItemPrices.get(i)[j]);
                } else {
                    ItemStack stack = sellItems.get(i)[j].getItem();
                    myname = stack.func_77973_b().getRegistryName() + ":" + stack.func_77960_j();
                    if (stack.func_77978_p() != null) {
                        myname = myname + " " + stack.func_77978_p().toString();
                    }
                }
                if (!sellItemMap.containsKey(myname)) {
                    sellItemMap.put(myname, itemPrices.get(i)[j]);
                    continue;
                }
                sellItemMap.put(myname, Float.valueOf(Math.max(sellItemMap.get(myname).floatValue(), itemPrices.get(i)[j].floatValue())));
            }
        }
    }

    public static void setShopLiquids(String[] buyNames, float[] buyPrices, String[] sellNames, float[] sellPrices) {
        int i;
        buyFluids = new FluidStack[buyNames.length];
        for (i = 0; i < buyNames.length; ++i) {
            ShopStock.buyFluids[i] = ShopStock.parseFluidString(buyNames[i]);
        }
        buyFluidPrices = buyPrices;
        for (i = 0; i < sellNames.length; ++i) {
            sellFluidMap.put(sellNames[i], Float.valueOf(sellPrices[i]));
        }
    }

    private static FluidStack parseFluidString(String s) {
        String[] split = s.split(" ");
        NBTTagCompound tag = new NBTTagCompound();
        if (split.length == 2) {
            try {
                tag = JsonToNBT.func_180713_a((String)split[1]);
            }
            catch (NBTException e) {
                AdminShop.logger.log(Level.ERROR, "Improperly formatted fluid nbt: " + s);
            }
        } else if (split.length > 2) {
            AdminShop.logger.log(Level.ERROR, "Improperly formatted fluid nbt: " + s);
        }
        return new FluidStack(FluidRegistry.getFluid((String)split[0]), 1, tag);
    }

    private static ItemStack parseItemString(String s) {
        if (s.charAt(0) == '<') {
            s = s.substring(1);
        }
        if (s.charAt(s.length() - 1) == '>') {
            s = s.substring(0, s.length() - 1);
        }
        NBTTagCompound nbt = null;
        if (s.contains("{")) {
            AdminShop.logger.log(Level.INFO, "Parsing item with NBT!");
            String nbtText = s.substring(s.indexOf(123), s.lastIndexOf(125));
            nbtText = nbtText + '}';
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtText);
            }
            catch (NBTException e) {
                AdminShop.logger.log(Level.ERROR, "Improperly formatted NBT in config!\n" + s);
            }
            s = s.substring(0, s.indexOf(123));
            s = s.trim();
            AdminShop.logger.log(Level.INFO, "Split Strings:\n" + s + "\n" + nbtText);
        }
        ItemStack toret = ItemStack.field_190927_a;
        String[] parts = s.split(":");
        if (parts.length == 2) {
            if (parts[0].equals("ore")) {
                return null;
            }
            toret = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s)), 1, 0, nbt);
        } else if (parts.length == 3) {
            String name = parts[0] + ":" + parts[1];
            int meta = 0;
            try {
                meta = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                AdminShop.logger.log(Level.ERROR, "Item string metadata improperly formatted! " + s);
                return ItemStack.field_190927_a;
            }
            toret = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name)), 1, meta, nbt);
        } else {
            AdminShop.logger.log(Level.ERROR, "Item string improperly formatted! Improper number of fields separated by colons! " + s);
            return ItemStack.field_190927_a;
        }
        if (nbt != null) {
            toret.func_77982_d(nbt);
        }
        AdminShop.logger.log(Level.INFO, "Item NBT: " + toret.func_77978_p());
        return toret;
    }

    public static ShopItemStack parseOredict(String s) {
        NBTTagCompound nbt = null;
        if (s.contains("{")) {
            AdminShop.logger.log(Level.INFO, "Parsing item with NBT!");
            String nbtText = s.substring(s.indexOf(123), s.lastIndexOf(125));
            nbtText = nbtText + '}';
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtText);
            }
            catch (NBTException e) {
                AdminShop.logger.log(Level.ERROR, "Improperly formatted NBT in config!\n" + s);
            }
            s = s.substring(0, s.indexOf(123));
            s = s.trim();
            AdminShop.logger.log(Level.INFO, "Split Strings:\n" + s + "\n" + nbtText);
        }
        ShopItemStack toret = new ShopItemStack(s.split(":")[1], nbt);
        return toret;
    }

    public static String getItemName(ItemStack item) {
        String name = item.func_77973_b().getRegistryName() + ":" + item.func_77960_j();
        if (item.func_77978_p() != null) {
            name = name + " " + item.func_77978_p().toString();
        }
        return name;
    }

    public static String getFluidName(FluidStack fluid) {
        String name = fluid.getFluid().getName();
        if (fluid.tag != null) {
            name = name + " " + fluid.tag.toString();
        }
        return name;
    }

    static {
        sellItemMap = new HashMap();
        sellFluidMap = new HashMap();
        sellItemOredictMap = new HashMap();
    }
}

