/*
 * Decompiled with CFR 0.152.
 */
package com.vnator.adminshop.blocks.shop;

import com.vnator.adminshop.AdminShop;
import com.vnator.adminshop.ModBlocks;
import com.vnator.adminshop.blocks.shop.ShopStock;
import com.vnator.adminshop.capabilities.money.IMoney;
import com.vnator.adminshop.capabilities.money.MoneyProvider;
import com.vnator.adminshop.packets.PacketHandler;
import com.vnator.adminshop.packets.PacketSendShopTransaction;
import com.vnator.adminshop.utils.GuiButtonShop;
import com.vnator.adminshop.utils.GuiButtonTab;
import com.vnator.adminshop.utils.TabButtonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class GuiShop
extends GuiContainer {
    private static final ResourceLocation BG_TEXT = new ResourceLocation("adminshop", "textures/gui/shopback.png");
    private static final int BUY_BUTTON_ID = 0;
    private static final int SELL_BUTTON_ID = 1;
    private InventoryPlayer playerInv;
    private EntityPlayer shopUser;
    private ArrayList<GuiButtonShop[]> buyButtons;
    private ArrayList<GuiButtonShop[]> sellButtons;
    private GuiButtonTab[] catBuyButtons;
    private GuiButtonTab[] catSellButtons;
    private int buyCat;
    private int sellCat;
    private boolean buyMode;

    public GuiShop(Container container, EntityPlayer player) {
        super(container);
        this.field_146999_f = 195;
        this.field_147000_g = 222;
        this.shopUser = player;
        this.playerInv = player.field_71071_by;
        this.buyCat = 0;
        this.sellCat = 0;
        this.buyMode = true;
    }

    public void func_73866_w_() {
        int j;
        int i;
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int buttonCounter = 0;
        GuiButtonTab buyTab = TabButtonBuilder.createBuySellButton(x + 8, y + 4, "Buy", true);
        buyTab.selectButton();
        this.field_146292_n.add(buyTab);
        GuiButtonTab sellTab = TabButtonBuilder.createBuySellButton(x + 33, y + 4, "Sell", false);
        this.field_146292_n.add(sellTab);
        buttonCounter = 2;
        this.catBuyButtons = new GuiButtonTab[Math.min(ShopStock.buyItems.size(), ShopStock.buyCategories.length)];
        for (i = 0; i < this.catBuyButtons.length; ++i) {
            this.catBuyButtons[i] = TabButtonBuilder.createCategoryButton(x + 9, y + 17 + 18 * i, ShopStock.buyCategories[i], i);
            this.field_146292_n.add(this.catBuyButtons[i]);
        }
        if (this.catBuyButtons.length > 0) {
            this.catBuyButtons[0].selectButton();
        }
        buttonCounter += this.catBuyButtons.length;
        this.catSellButtons = new GuiButtonTab[Math.min(ShopStock.sellItems.size(), ShopStock.sellCategories.length)];
        TabButtonBuilder.createNewGroup();
        for (i = 0; i < this.catSellButtons.length; ++i) {
            this.catSellButtons[i] = TabButtonBuilder.createCategoryButton(x + 9, y + 17 + 18 * i, ShopStock.sellCategories[i], i);
            this.catSellButtons[i].field_146124_l = false;
            this.catSellButtons[i].field_146125_m = false;
            this.field_146292_n.add(this.catSellButtons[i]);
        }
        if (this.catSellButtons.length > 0) {
            this.catSellButtons[0].selectButton();
        }
        buttonCounter += this.catSellButtons.length;
        this.buyButtons = new ArrayList();
        this.sellButtons = new ArrayList();
        for (i = 0; i < ShopStock.buyItems.size(); ++i) {
            this.buyButtons.add(new GuiButtonShop[ShopStock.buyItems.get(i).length]);
            for (j = 0; j < ShopStock.buyItems.get(i).length; ++j) {
                this.buyButtons.get((int)i)[j] = new GuiButtonShop(buttonCounter, x + 62 + 18 * (j % 7), y + 18 + 18 * (j / 7), ShopStock.buyItems.get(i)[j], ShopStock.buyItemPrices.get(i)[j].floatValue(), true, this.field_146296_j);
                this.field_146292_n.add(this.buyButtons.get(i)[j]);
                this.buyButtons.get((int)i)[j].category = (short)i;
                this.buyButtons.get((int)i)[j].index = j;
                if (i > 0) {
                    this.buyButtons.get((int)i)[j].field_146125_m = false;
                    this.buyButtons.get((int)i)[j].field_146124_l = false;
                }
                ++buttonCounter;
            }
        }
        buttonCounter = 0;
        for (i = 0; i < ShopStock.sellItems.size(); ++i) {
            this.sellButtons.add(new GuiButtonShop[ShopStock.sellItems.get(i).length]);
            for (j = 0; j < ShopStock.sellItems.get(i).length; ++j) {
                ItemStack sellSample = ShopStock.sellItems.get(i)[j].isOreDict() ? (ItemStack)OreDictionary.getOres((String)ShopStock.sellItems.get(i)[j].getOreName()).get(0) : ShopStock.sellItems.get(i)[j].getItem();
                this.sellButtons.get((int)i)[j] = new GuiButtonShop(buttonCounter, x + 62 + 18 * (j % 7), y + 18 + 18 * (j / 7), sellSample, ShopStock.sellItemPrices.get(i)[j].floatValue(), false, this.field_146296_j);
                this.field_146292_n.add(this.sellButtons.get(i)[j]);
                this.sellButtons.get((int)i)[j].category = (short)i;
                this.sellButtons.get((int)i)[j].index = j;
                this.sellButtons.get((int)i)[j].field_146125_m = false;
                this.sellButtons.get((int)i)[j].field_146124_l = false;
                ++buttonCounter;
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BG_TEXT);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiButtonShop[] myarr;
        String name = I18n.func_135052_a((String)(ModBlocks.shop.func_149739_a() + ".name"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 16, this.field_147000_g - 94, 0x404040);
        IMoney imon = (IMoney)this.shopUser.getCapability(MoneyProvider.MONEY_CAPABILITY, null);
        String money = imon.getFormattedMoney();
        this.field_146289_q.func_78276_b(money, 178 - this.field_146289_q.func_78256_a(money), this.field_147000_g - 94, 0x404040);
        for (GuiButtonShop but : myarr = this.buyMode ? this.buyButtons.get(this.buyCat) : this.sellButtons.get(this.sellCat)) {
            if (but.field_146128_h >= mouseX || but.field_146128_h + but.field_146120_f <= mouseX || but.field_146129_i >= mouseY || but.field_146129_i + but.field_146121_g <= mouseY) continue;
            this.func_146283_a(but.getTooltipStrings(this.shopUser), mouseX - (this.field_146294_l - this.field_146999_f) / 2, mouseY - (this.field_146295_m - this.field_147000_g) / 2);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiButtonShop) {
            AdminShop.logger.log(Level.DEBUG, "GuiShopButton pressed!");
            GuiButtonShop shopbutton = (GuiButtonShop)button;
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSendShopTransaction(shopbutton.category, shopbutton.index, shopbutton.getItemStack().func_190916_E(), this.buyMode));
        } else if (button instanceof GuiButtonTab) {
            GuiButtonTab tabbutton = (GuiButtonTab)button;
            tabbutton.selectButton();
            if (tabbutton.isBSButton()) {
                this.switchBSTab(tabbutton);
            } else if (tabbutton.isCategoryButton()) {
                this.switchCatTab(tabbutton);
            }
        }
    }

    private void switchBSTab(GuiButtonTab tabbutton) {
        block9: {
            int i;
            block8: {
                int i2;
                if (!tabbutton.isBuy()) break block8;
                this.buyMode = true;
                for (i2 = 0; i2 < this.sellButtons.get(this.sellCat).length; ++i2) {
                    this.sellButtons.get((int)this.sellCat)[i2].field_146124_l = false;
                    this.sellButtons.get((int)this.sellCat)[i2].field_146125_m = false;
                }
                for (i2 = 0; i2 < this.buyButtons.get(this.buyCat).length; ++i2) {
                    this.buyButtons.get((int)this.buyCat)[i2].field_146124_l = true;
                    this.buyButtons.get((int)this.buyCat)[i2].field_146125_m = true;
                }
                for (GuiButtonTab but : this.catSellButtons) {
                    but.field_146124_l = false;
                    but.field_146125_m = false;
                }
                for (GuiButtonTab but : this.catBuyButtons) {
                    but.field_146124_l = true;
                    but.field_146125_m = true;
                }
                break block9;
            }
            if (!tabbutton.isSell()) break block9;
            this.buyMode = false;
            for (i = 0; i < this.buyButtons.get(this.buyCat).length; ++i) {
                this.buyButtons.get((int)this.buyCat)[i].field_146124_l = false;
                this.buyButtons.get((int)this.buyCat)[i].field_146125_m = false;
            }
            for (i = 0; i < this.sellButtons.get(this.sellCat).length; ++i) {
                this.sellButtons.get((int)this.sellCat)[i].field_146124_l = true;
                this.sellButtons.get((int)this.sellCat)[i].field_146125_m = true;
            }
            for (GuiButtonTab but : this.catSellButtons) {
                but.field_146124_l = true;
                but.field_146125_m = true;
            }
            for (GuiButtonTab but : this.catBuyButtons) {
                but.field_146124_l = false;
                but.field_146125_m = false;
            }
        }
    }

    private void switchCatTab(GuiButtonTab tabbutton) {
        GuiButtonShop[] newbuttons = null;
        GuiButtonShop[] oldbuttons = null;
        if (this.buyMode) {
            newbuttons = this.buyButtons.get(tabbutton.getCategory());
            oldbuttons = this.buyButtons.get(this.buyCat);
            this.buyCat = tabbutton.getCategory();
        } else {
            newbuttons = this.sellButtons.get(tabbutton.getCategory());
            oldbuttons = this.sellButtons.get(this.sellCat);
            this.sellCat = tabbutton.getCategory();
        }
        for (GuiButtonShop but : oldbuttons) {
            but.field_146125_m = false;
            but.field_146124_l = false;
        }
        for (GuiButtonShop but : newbuttons) {
            but.field_146125_m = true;
            but.field_146124_l = true;
        }
    }

    private void buyItem(GuiButtonShop shopbutton) {
        IItemHandler inventory = (IItemHandler)this.shopUser.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack tobuy = shopbutton.getItemStack();
        ItemStack returned = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)tobuy, (boolean)true);
        float price = shopbutton.getPrice(tobuy.func_190916_E() - returned.func_190916_E());
        boolean success = ((IMoney)this.shopUser.getCapability(MoneyProvider.MONEY_CAPABILITY, null)).withdraw(price);
        if (success) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)this.shopUser, (ItemStack)tobuy);
        } else {
            AdminShop.logger.log(Level.ERROR, "Not enough money to perform transaction!");
        }
    }
}

