/*
 * Decompiled with CFR 0.152.
 */
package com.vnator.adminshop.blocks.seller;

import com.vnator.adminshop.ConfigHandler;
import com.vnator.adminshop.blocks.seller.SellerBattery;
import com.vnator.adminshop.blocks.shop.ShopStock;
import com.vnator.adminshop.capabilities.BalanceAdapter;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySeller
extends TileEntity
implements ITickable,
IFluidHandler {
    private String player;
    private SellerBattery battery = new SellerBattery(1000000000, this);
    private FluidTank tank = new FluidTank(1000000);
    private ItemStackHandler inventory = new ItemStackHandler(3){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }
    };

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.player != null) {
            IEnergyStorage exBat;
            int power;
            if (!this.inventory.getStackInSlot(0).func_190926_b()) {
                float money = 0.0f;
                ItemStack item = this.inventory.getStackInSlot(0);
                String name = item.func_77973_b().getRegistryName() + ":" + item.func_77960_j();
                if (item.func_77978_p() != null) {
                    name = name + " " + item.func_77978_p().toString();
                }
                if (ShopStock.sellItemMap.containsKey(name)) {
                    money = ShopStock.sellItemMap.get(name).floatValue() * (float)item.func_190916_E();
                } else {
                    int[] oreIds = OreDictionary.getOreIDs((ItemStack)item);
                    float maxVal = 0.0f;
                    for (int i : oreIds) {
                        maxVal = Math.max(maxVal, ShopStock.sellItemOredictMap.get(i).floatValue());
                    }
                    money = maxVal * (float)item.func_190916_E();
                }
                BalanceAdapter.deposit(this.field_145850_b, this.player, money);
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                this.func_70296_d();
            }
            if (!this.inventory.getStackInSlot(1).func_190926_b()) {
                IFluidHandlerItem exTank = FluidUtil.getFluidHandler((ItemStack)this.inventory.getStackInSlot(1));
                FluidStack liquid = exTank.drain(1000, true);
                if (liquid != null) {
                    float money = ShopStock.sellFluidMap.get(ShopStock.getFluidName(liquid)).floatValue();
                    BalanceAdapter.deposit(this.field_145850_b, this.player, money);
                    this.inventory.setStackInSlot(1, exTank.getContainer());
                }
                this.func_70296_d();
            }
            if (!this.inventory.getStackInSlot(2).func_190926_b() && (power = (exBat = (IEnergyStorage)this.inventory.getStackInSlot(2).getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(exBat.getEnergyStored(), false)) != 0) {
                float money = (float)power * ConfigHandler.Sellable_Items.forgeEnergyPrice;
                BalanceAdapter.deposit(this.field_145850_b, this.player, money);
                this.func_70296_d();
            }
            if (this.tank.getFluidAmount() >= ConfigHandler.GENERAL_CONFIGS.liquidSellPacketSize) {
                String name = this.tank.getFluid().getFluid().getName();
                if (this.tank.getFluid().tag != null) {
                    name = name + " " + this.tank.getFluid().tag.toString();
                }
                float money = ShopStock.sellFluidMap.get(name).floatValue() * (float)this.tank.getFluidAmount();
                BalanceAdapter.deposit(this.field_145850_b, this.player, money);
                this.tank.drain(this.tank.getCapacity(), true);
                this.func_70296_d();
            }
            if (this.battery.getEnergyStored() >= ConfigHandler.GENERAL_CONFIGS.powerSellPacketSize) {
                int cap = this.battery.deleteEnergy();
                float money = (float)cap * ConfigHandler.Sellable_Items.forgeEnergyPrice;
                BalanceAdapter.deposit(this.field_145850_b, this.player, money);
            }
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        String name = resource.getFluid().getName();
        if (resource.tag != null) {
            name = name + " " + resource.tag.toString();
        }
        if (ShopStock.sellFluidMap.containsKey(name)) {
            this.func_70296_d();
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.player != null) {
            compound.func_74778_a("player", this.player);
        }
        this.tank.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.player = compound.func_74779_i("player");
        if (this.player == null || this.player.equals("")) {
            this.player = null;
        }
        this.tank.readFromNBT(compound);
        super.func_145839_a(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.battery);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    public String getPlayer() {
        return this.player;
    }
}

