/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.tile;

import com.buuz135.portality.block.BlockController;
import com.buuz135.portality.block.BlockFrame;
import com.buuz135.portality.block.module.IPortalModule;
import com.buuz135.portality.data.PortalDataManager;
import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.data.PortalLinkData;
import com.buuz135.portality.handler.ChunkLoaderHandler;
import com.buuz135.portality.handler.CustomEnergyStorageHandler;
import com.buuz135.portality.handler.TeleportHandler;
import com.buuz135.portality.proxy.PortalityConfig;
import com.buuz135.portality.tile.TileBase;
import com.buuz135.portality.util.BlockPosUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileController
extends TileBase
implements ITickable {
    private static String NBT_FORMED = "Formed";
    private static String NBT_TICK = "Tick";
    private static String NBT_LENGTH = "Length";
    private static String NBT_PORTAL = "Portal";
    private static String NBT_LINK = "Link";
    private static String NBT_DISPLAY = "Display";
    private static String NBT_ONCE = "Once";
    private boolean isFormed = false;
    private int tick = 0;
    private int length = 0;
    private boolean onceCall = false;
    private boolean display = true;
    private PortalInformation information;
    private PortalLinkData linkData;
    private CustomEnergyStorageHandler energy;
    private TeleportHandler teleportHandler = new TeleportHandler(this);
    private List<BlockPos> modules = new ArrayList<BlockPos>();

    public TileController() {
        this.energy = new CustomEnergyStorageHandler(PortalityConfig.MAX_PORTAL_POWER, PortalityConfig.MAX_PORTAL_POWER_IN, 0, 0);
    }

    public void func_73660_a() {
        if (this.isActive()) {
            this.teleportHandler.tick();
            if (this.linkData != null) {
                for (Entity entity : this.field_145850_b.func_72872_a(Entity.class, this.getPortalArea())) {
                    this.teleportHandler.addEntityToTeleport(entity, this.linkData);
                }
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isActive() && this.linkData != null) {
            this.energy.extractEnergyInternal((this.linkData.isCaller() ? 2 : 1) * this.length * PortalityConfig.POWER_PORTAL_TICK, false);
            if (this.energy.getEnergyStored() == 0) {
                this.closeLink();
            }
        }
        ++this.tick;
        if (this.tick >= 10) {
            this.tick = 0;
            this.length = this.checkArea();
            this.workModules();
            this.getPortalInfo();
            this.markForUpdate();
            if (this.linkData != null) {
                ChunkLoaderHandler.addPortalAsChunkloader(this);
                TileEntity tileEntity = this.field_145850_b.func_73046_m().func_71218_a(this.linkData.getDimension()).func_175625_s(this.linkData.getPos());
                if (!(tileEntity instanceof TileController) || ((TileController)tileEntity).getLinkData().getDimension() != this.field_145850_b.field_73011_w.getDimension() || !((TileController)tileEntity).getLinkData().getPos().equals((Object)this.field_174879_c)) {
                    this.closeLink();
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74757_a(NBT_FORMED, this.isFormed);
        compound.func_74768_a(NBT_TICK, this.tick);
        compound.func_74768_a(NBT_LENGTH, this.length);
        this.energy.writeToNBT(compound);
        compound.func_74757_a(NBT_ONCE, this.onceCall);
        compound.func_74757_a(NBT_DISPLAY, this.display);
        if (this.information != null) {
            compound.func_74782_a(NBT_PORTAL, (NBTBase)this.information.writetoNBT());
        }
        if (this.linkData != null) {
            compound.func_74782_a(NBT_LINK, (NBTBase)this.linkData.writeToNBT());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.isFormed = compound.func_74767_n(NBT_FORMED);
        this.tick = compound.func_74762_e(NBT_TICK);
        this.length = compound.func_74762_e(NBT_LENGTH);
        if (compound.func_74764_b(NBT_PORTAL)) {
            this.information = PortalInformation.readFromNBT(compound.func_74775_l(NBT_PORTAL));
        }
        if (compound.func_74764_b(NBT_LINK)) {
            this.linkData = PortalLinkData.readFromNBT(compound.func_74775_l(NBT_LINK));
        }
        this.energy.readFromNBT(compound);
        this.onceCall = compound.func_74767_n(NBT_ONCE);
        this.display = compound.func_74767_n(NBT_DISPLAY);
        super.func_145839_a(compound);
    }

    private int checkArea() {
        BlockPos center = this.field_174879_c.func_177967_a(EnumFacing.UP, 2);
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockController.FACING);
        boolean isSouthNorth = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH;
        int length = 0;
        this.modules.clear();
        while (true) {
            AxisAlignedBB box = new AxisAlignedBB((double)(center.func_177958_n() + (isSouthNorth ? 2 : 0)), (double)(center.func_177956_o() + 2), (double)(center.func_177952_p() + (!isSouthNorth ? 2 : 0)), (double)(center.func_177958_n() + (isSouthNorth ? -2 : 0)), (double)(center.func_177956_o() - 2), (double)(center.func_177952_p() + (!isSouthNorth ? -2 : 0)));
            List<BlockPos> blocks = BlockPosUtils.getBlockPosInAABB(box);
            BlockPos finalCenter = center;
            blocks.removeIf(pos1 -> BlockPosUtils.getBlockPosInAABB(new AxisAlignedBB((double)(finalCenter.func_177958_n() + (isSouthNorth ? 1 : 0)), (double)(finalCenter.func_177956_o() + 1), (double)(finalCenter.func_177952_p() + (!isSouthNorth ? 1 : 0)), (double)(finalCenter.func_177958_n() + (isSouthNorth ? -1 : 0)), (double)(finalCenter.func_177956_o() - 1), (double)(finalCenter.func_177952_p() + (!isSouthNorth ? -1 : 0)))).contains(pos1));
            for (BlockPos pos : blocks) {
                if (this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof IPortalModule) {
                    this.modules.add(pos);
                    continue;
                }
                if (length == 0 && pos.func_177958_n() == center.func_177958_n() && pos.func_177956_o() == center.func_177956_o() - 2 && pos.func_177952_p() == center.func_177952_p() && this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof BlockController || this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof BlockFrame) continue;
                return length;
            }
            if (++length > PortalityConfig.MAX_PORTAL_LENGTH) {
                return length;
            }
            center = center.func_177972_a(facing.func_176734_d());
        }
    }

    private void workModules() {
        boolean interdimensional = false;
        for (BlockPos pos : this.modules) {
            Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IPortalModule)) continue;
            if (((IPortalModule)block).allowsInterdimensionalTravel()) {
                interdimensional = true;
            }
            ((IPortalModule)block).work(this, pos);
        }
        PortalDataManager.setPortalInterdimensional(this.field_145850_b, this.field_174879_c, interdimensional);
    }

    public AxisAlignedBB getPortalArea() {
        BlockPos center = this.field_174879_c.func_177967_a(EnumFacing.UP, 2);
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockController.FACING);
        boolean isSouthNorth = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH;
        BlockPos corner1 = new BlockPos(center.func_177958_n() + (isSouthNorth ? 2 : 0), center.func_177956_o() + 2, center.func_177952_p() + (!isSouthNorth ? 2 : 0)).func_177967_a(facing.func_176734_d(), this.length - 1);
        BlockPos corner2 = new BlockPos(center.func_177958_n() + (isSouthNorth ? -2 : 0), center.func_177956_o() - 2, center.func_177952_p() + (!isSouthNorth ? -2 : 0));
        return new AxisAlignedBB(corner1, corner2);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getPortalArea();
    }

    private void getPortalInfo() {
        this.information = PortalDataManager.getInfoFromPos(this.field_145850_b, this.field_174879_c);
    }

    public void togglePrivacy() {
        PortalDataManager.setPortalPrivacy(this.field_145850_b, this.field_174879_c, !this.information.isPrivate());
        this.getPortalInfo();
        this.markForUpdate();
    }

    public boolean isFormed() {
        return this.length >= 3;
    }

    public int getTick() {
        return this.tick;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isPrivate() {
        return this.information != null && this.information.isPrivate();
    }

    public UUID getOwner() {
        if (this.information != null) {
            return this.information.getOwner();
        }
        return null;
    }

    public String getName() {
        if (this.information != null) {
            return this.information.getName();
        }
        return "";
    }

    public void setName(String name) {
        PortalDataManager.setPortalName(this.field_145850_b, this.func_174877_v(), name);
        this.getPortalInfo();
        this.markForUpdate();
    }

    public boolean isInterdimensional() {
        return this.information != null && this.information.isInterdimensional();
    }

    public ItemStack getDisplay() {
        if (this.information != null) {
            return this.information.getDisplay();
        }
        return ItemStack.field_190927_a;
    }

    public void setDisplayNameEnabled(ItemStack display) {
        PortalDataManager.setPortalDisplay(this.field_145850_b, this.field_174879_c, display);
        this.getPortalInfo();
        this.markForUpdate();
    }

    public void linkTo(PortalLinkData data, PortalLinkData.PortalCallType type) {
        WorldServer world;
        TileEntity entity;
        if (type == PortalLinkData.PortalCallType.FORCE) {
            this.closeLink();
        }
        if (this.linkData != null) {
            return;
        }
        if (type == PortalLinkData.PortalCallType.SINGLE) {
            this.onceCall = true;
        }
        if (data.isCaller() && (entity = (world = this.field_145850_b.func_73046_m().func_71218_a(data.getDimension())).func_175625_s(data.getPos())) instanceof TileController) {
            data.setName(((TileController)entity).getName());
            ((TileController)entity).linkTo(new PortalLinkData(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, false, this.getName()), type);
            int power = PortalityConfig.PORTAL_POWER_OPEN_INTERDIMENSIONAL;
            if (entity.func_145831_w().equals(this.field_145850_b)) {
                power = (int)this.field_174879_c.func_185332_f(entity.func_174877_v().func_177958_n(), entity.func_174877_v().func_177952_p(), entity.func_174877_v().func_177956_o()) * this.length;
            }
            this.energy.extractEnergyInternal(power, false);
        }
        PortalDataManager.setActiveStatus(this.field_145850_b, this.field_174879_c, true);
        this.linkData = data;
    }

    public void closeLink() {
        if (this.linkData != null) {
            PortalDataManager.setActiveStatus(this.field_145850_b, this.field_174879_c, false);
            WorldServer world = this.field_145850_b.func_73046_m().func_71218_a(this.linkData.getDimension());
            TileEntity entity = world.func_175625_s(this.linkData.getPos());
            this.linkData = null;
            if (entity instanceof TileController) {
                ((TileController)entity).closeLink();
            }
        }
        ChunkLoaderHandler.removePortalAsChunkloader(this);
    }

    public boolean isActive() {
        return this.information != null && this.information.isActive();
    }

    public PortalLinkData getLinkData() {
        return this.linkData;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public CustomEnergyStorageHandler getEnergy() {
        return this.energy;
    }

    public boolean isDisplayNameEnabled() {
        return this.display;
    }

    public void setDisplayNameEnabled(boolean display) {
        this.display = display;
    }

    public List<BlockPos> getModules() {
        return this.modules;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energy);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean teleportedEntity() {
        if (this.onceCall) {
            this.onceCall = false;
            this.closeLink();
            return true;
        }
        return false;
    }
}

