/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.network;

import com.buuz135.portality.proxy.PortalityConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PortalTeleportMessage
implements IMessage {
    private int facing;
    private int length;

    public PortalTeleportMessage(int facing, int length) {
        this.facing = facing;
        this.length = length;
    }

    public PortalTeleportMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.facing = buf.readInt();
        this.length = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.facing);
        buf.writeInt(this.length);
    }

    public static class Handler
    implements IMessageHandler<PortalTeleportMessage, IMessage> {
        public IMessage onMessage(PortalTeleportMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(new SoundEvent(new ResourceLocation("entity.shulker.teleport")), 1.0f, 1.0f);
                if (PortalityConfig.LAUNCH_PLAYERS) {
                    EnumFacing facing = EnumFacing.values()[message.facing];
                    Vec3d vector = new Vec3d(facing.func_176730_m()).func_186678_a((double)(2 * message.length) / (double)PortalityConfig.MAX_PORTAL_LENGTH);
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    player.field_70159_w = vector.field_72450_a;
                    player.field_70181_x = vector.field_72448_b;
                    player.field_70179_y = vector.field_72449_c;
                }
            });
            return null;
        }
    }
}

