/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.gui;

import com.buuz135.portality.data.PortalInformation;
import com.buuz135.portality.gui.ContainerController;
import com.buuz135.portality.gui.GuiButtonImagePortal;
import com.buuz135.portality.gui.IHasTooltip;
import com.buuz135.portality.gui.TooltipGuiButton;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiPortals
extends GuiContainer {
    private ContainerController controller;
    private int pointer;
    private List<PortalInformation> informationList;

    public GuiPortals(ContainerController controller) {
        super((Container)controller);
        this.controller = controller;
        this.pointer = 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.informationList != null && !this.informationList.isEmpty()) {
            this.addPortalButtons();
        }
    }

    public void refresh(List<PortalInformation> informationList) {
        this.informationList = informationList;
        this.pointer = 0;
        informationList.removeIf(information -> information.isPrivate() && !information.getOwner().equals(this.field_146297_k.field_71439_g.func_110124_au()));
        informationList.sort((o1, o2) -> Boolean.compare(o2.isPrivate(), o1.isPrivate()));
        informationList.removeIf(information -> information.getDimension() == this.controller.getController().func_145831_w().field_73011_w.getDimension() && information.getLocation().equals((Object)this.controller.getController().func_174877_v()));
        this.field_146292_n.clear();
        this.addPortalButtons();
    }

    private void addPortalButtons() {
        this.field_146292_n.clear();
        for (int i = 0; i < 4; ++i) {
            if (this.informationList.size() <= this.pointer + i) continue;
            GuiButtonImagePortal buttonImage = new GuiButtonImagePortal(this.informationList.get(this.pointer + i), i + 3, this.field_147003_i + 5, this.field_147009_r + 6 + 39 * i, 166, 36, 0, 166, 0, new ResourceLocation("portality", "textures/gui/portals.png"), this.controller.getController());
            this.func_189646_b((GuiButton)buttonImage);
        }
        this.func_189646_b(new TooltipGuiButton(0, this.field_147003_i, this.field_147009_r + this.field_147000_g, 20, 20, "<"){

            @Override
            public List<String> getTooltip() {
                return Arrays.asList(I18n.func_135052_a((String)"portality.gui.portals.previous_page", (Object[])new Object[0]));
            }

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (this.func_146115_a()) {
                    GuiPortals.this.pointer = Math.max(0, GuiPortals.this.pointer - 4);
                    GuiPortals.this.addPortalButtons();
                }
                return super.func_146116_c(mc, mouseX, mouseY);
            }
        });
        this.func_189646_b(new TooltipGuiButton(1, this.field_147003_i + this.field_146999_f - 20, this.field_147009_r + this.field_147000_g, 20, 20, ">"){

            @Override
            public List<String> getTooltip() {
                return Arrays.asList(I18n.func_135052_a((String)"portality.gui.portals.next_page", (Object[])new Object[0]));
            }

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                if (this.func_146115_a() && GuiPortals.this.pointer + 4 < GuiPortals.this.informationList.size()) {
                    GuiPortals.this.pointer = GuiPortals.this.pointer + 4;
                    GuiPortals.this.addPortalButtons();
                }
                return super.func_146116_c(mc, mouseX, mouseY);
            }
        });
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("portality", "textures/gui/portals.png"));
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.informationList != null) {
            String name = I18n.func_135052_a((String)"portality.gui.portals.page", (Object[])new Object[0]) + " " + ((int)Math.ceil((double)this.pointer / 4.0) + 1) + "/" + (int)Math.ceil((double)this.informationList.size() / 4.0);
            this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, this.field_147000_g + 7, 0xFFFFFF);
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof IHasTooltip) || !button.func_146115_a()) continue;
            this.func_146283_a(((IHasTooltip)button).getTooltip(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }
}

