/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.InventoryGenerators;
import com.kjmaster.inventorygenerators.client.IHasModel;
import com.kjmaster.inventorygenerators.client.KeyHandler;
import com.kjmaster.inventorygenerators.common.generators.FuelWithSlot;
import com.kjmaster.inventorygenerators.common.generators.IInventoryGenerator;
import com.kjmaster.kjlib.common.energy.IItemEnergy;
import com.kjmaster.kjlib.common.energy.InvEnergyStorage;
import com.kjmaster.kjlib.common.items.ItemBase;
import com.kjmaster.kjlib.utils.CapabilityUtils;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInventoryGenerator
extends ItemBase
implements IInventoryGenerator,
IItemEnergy,
IHasModel {
    public ItemInventoryGenerator(String name) {
        super(name, InventoryGenerators.invGenTab, 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        final ModelResourceLocation onModel = new ModelResourceLocation(this.getRegistryName() + "_on", "inventory");
        final ModelResourceLocation offModel = new ModelResourceLocation(this.getRegistryName() + "_off", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{onModel, offModel});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (ItemInventoryGenerator.this.isOn(stack) && ItemInventoryGenerator.this.getBurnTime(stack) > 0) {
                    return onModel;
                }
                return offModel;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer && !world.field_72995_K && stack.func_77973_b() instanceof IInventoryGenerator) {
            IInventoryGenerator inventoryGenerator = (IInventoryGenerator)stack.func_77973_b();
            if (!stack.func_77942_o()) {
                inventoryGenerator.giveTagCompound(stack);
            } else if (stack.func_77942_o()) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (!tagCompound.func_74764_b("Charging")) {
                    tagCompound.func_74757_a("Charging", false);
                }
                if (!tagCompound.func_74764_b("Energy")) {
                    tagCompound.func_74768_a("Energy", 0);
                }
                if (!tagCompound.func_74764_b("Fuel")) {
                    NBTTagCompound fuelTagCompound = ItemStack.field_190927_a.func_77955_b(new NBTTagCompound());
                    tagCompound.func_74782_a("Fuel", (NBTBase)fuelTagCompound);
                }
                if (!tagCompound.func_74764_b("BurnTime")) {
                    tagCompound.func_74768_a("BurnTime", 0);
                }
                if (!tagCompound.func_74764_b("Slot")) {
                    tagCompound.func_74768_a("Slot", 0);
                }
            }
            if (inventoryGenerator.isOn(stack)) {
                EntityPlayer player = (EntityPlayer)entity;
                if ((inventoryGenerator.getBurnTime(stack) <= 0 || this.getFuel(stack).func_190926_b()) && this.getInternalEnergyStored(stack) != this.getMaxEnergyStored(stack)) {
                    this.setBurnTime(stack, 0);
                    FuelWithSlot fuelWithSlot = inventoryGenerator.getFuelWithSlot(player);
                    ItemStack fuel = fuelWithSlot.getFuel();
                    this.addFuel(stack, fuel);
                    int slot = fuelWithSlot.getSlot();
                    inventoryGenerator.setBurnTime(stack, inventoryGenerator.calculateTime(fuel));
                    inventoryGenerator.setSlot(stack, slot);
                    fuel.func_190918_g(1);
                } else if (this.getInternalEnergyStored(stack) != this.getMaxEnergyStored(stack)) {
                    inventoryGenerator.setBurnTime(stack, inventoryGenerator.getBurnTime(stack) - 1);
                    int rfToGive = inventoryGenerator.calculatePower(stack);
                    inventoryGenerator.receiveInternalEnergy(stack, rfToGive);
                }
                if (inventoryGenerator.isInChargingMode(stack)) {
                    ArrayList<ItemStack> chargeables = inventoryGenerator.getChargeables(player);
                    inventoryGenerator.giveEnergyToChargeables(chargeables, stack);
                }
            }
        }
    }

    @Override
    public void giveTagCompound(ItemStack stack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NBTTagCompound fuelTagCompound = ItemStack.field_190927_a.func_77955_b(new NBTTagCompound());
        nbtTagCompound.func_74782_a("Fuel", (NBTBase)fuelTagCompound);
        nbtTagCompound.func_74757_a("On", false);
        nbtTagCompound.func_74757_a("Charging", false);
        nbtTagCompound.func_74768_a("Energy", 0);
        nbtTagCompound.func_74768_a("BurnTime", 0);
        nbtTagCompound.func_74768_a("Slot", 0);
        stack.func_77982_d(nbtTagCompound);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.turnOn(stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new InvEnergyStorage(this.getMaxEnergyStored(stack), this.getReceive(), this.getSend(), stack, (IItemEnergy)this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
    }

    public void addMoreInformation(ItemStack stack, List<String> tooltip) {
        if (this.isOn(stack)) {
            tooltip.add(StringHelper.getNoticeText((String)"info.invgens.1"));
            tooltip.add(StringHelper.getDeactivationText((String)"info.invgens.2"));
        } else {
            tooltip.add(StringHelper.getActivationText((String)"info.invgens.3"));
        }
        if (this.isInChargingMode(stack)) {
            tooltip.add(StringHelper.getNoticeText((String)"info.invgens.modeOn"));
        } else {
            tooltip.add(StringHelper.getNoticeText((String)"info.invgens.modeOff"));
        }
        tooltip.add(StringHelper.localizeFormat((String)"info.invgens.mode", (Object[])new Object[]{StringHelper.getKeyName((int)KeyHandler.MODE_KEY.func_151463_i())}));
        tooltip.add(StringHelper.localize((String)"info.invgens.charge") + ": " + StringHelper.getScaledNumber((long)this.getInternalEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add(StringHelper.localize((String)"info.invgens.send") + "/" + StringHelper.localize((String)"info.invgens.receive") + ": " + StringHelper.formatNumber((long)this.getSend()) + "/" + StringHelper.formatNumber((long)this.getReceive()) + " RF/t");
        tooltip.add(StringHelper.localize((String)"info.invgens.burnTimeLeft") + ": " + StringHelper.formatNumber((long)this.getBurnTime(stack)));
    }

    @Override
    public ArrayList<ItemStack> getChargeables(EntityPlayer player) {
        ArrayList<ItemStack> chargeables = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            IEnergyStorage energyStorage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)invStack, (Capability)CapabilityEnergy.ENERGY, null);
            if (energyStorage == null || energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) continue;
            chargeables.add(invStack);
        }
        return chargeables;
    }

    @Override
    public void giveEnergyToChargeables(ArrayList<ItemStack> chargeables, ItemStack stack) {
        for (ItemStack chargeableStack : chargeables) {
            IEnergyStorage storage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)chargeableStack, (Capability)CapabilityEnergy.ENERGY, null);
            int energySent = storage.receiveEnergy(this.getInternalEnergyStored(stack) / chargeables.size(), false);
            this.extractEnergy(stack, energySent, false);
        }
        chargeables.clear();
    }

    @Override
    public void receiveInternalEnergy(ItemStack stack, int energy) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("Energy")) {
            int stored = this.getInternalEnergyStored(stack);
            int newEnergy = stored + energy;
            nbtTagCompound.func_74768_a("Energy", newEnergy);
        }
    }

    @Override
    public int getInternalEnergyStored(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (stack.func_77942_o() && (tagCompound = stack.func_77978_p()).func_74764_b("Energy")) {
            return tagCompound.func_74762_e("Energy");
        }
        return 0;
    }

    @Override
    public FuelWithSlot getFuelWithSlot(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.isItemValid(stack)) continue;
            return new FuelWithSlot(stack, i);
        }
        return new FuelWithSlot(ItemStack.field_190927_a, 0);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return false;
    }

    @Override
    public int calculateTime(ItemStack stack) {
        return 0;
    }

    @Override
    public int calculatePower(ItemStack stack) {
        return Math.min(this.getMaxEnergyStored(stack) - this.getInternalEnergyStored(stack), this.getSend());
    }

    @Override
    public boolean isInChargingMode(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("Charging")) {
            return nbtTagCompound.func_74767_n("Charging");
        }
        return false;
    }

    @Override
    public void changeMode(ItemStack stack) {
        if (this.isInChargingMode(stack)) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            nbtTagCompound.func_74757_a("Charging", false);
        } else if (stack.func_77942_o()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            tagCompound.func_74757_a("Charging", true);
        }
    }

    @Override
    public boolean isOn(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("On")) {
            return nbtTagCompound.func_74767_n("On");
        }
        return false;
    }

    @Override
    public void turnOn(ItemStack stack) {
        if (this.isOn(stack)) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            nbtTagCompound.func_74757_a("On", false);
        } else if (stack.func_77942_o()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            tagCompound.func_74757_a("On", true);
        }
    }

    @Override
    public int getBurnTime(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("BurnTime")) {
            return nbtTagCompound.func_74762_e("BurnTime");
        }
        return 0;
    }

    @Override
    public void setBurnTime(ItemStack stack, int burnTime) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("BurnTime")) {
            nbtTagCompound.func_74768_a("BurnTime", burnTime);
        }
    }

    @Override
    public ItemStack getFuel(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("Fuel")) {
            NBTTagCompound fuelTagCompound = nbtTagCompound.func_74775_l("Fuel");
            return new ItemStack(fuelTagCompound);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void addFuel(ItemStack stack, ItemStack fuel) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("Fuel")) {
            NBTTagCompound fuelTagCompound = fuel.func_77955_b(new NBTTagCompound());
            nbtTagCompound.func_74782_a("Fuel", (NBTBase)fuelTagCompound);
        }
    }

    @Override
    public int getSlot(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("Slot")) {
            return nbtTagCompound.func_74762_e("Slot");
        }
        return 0;
    }

    @Override
    public void setSlot(ItemStack stack, int slot) {
        NBTTagCompound nbtTagCompound;
        if (stack.func_77942_o() && (nbtTagCompound = stack.func_77978_p()).func_74764_b("Slot")) {
            nbtTagCompound.func_74768_a("Slot", slot);
        }
    }

    public int getMaxEnergyStored(ItemStack container) {
        return 100000;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            NBTTagCompound newTagCompound = new NBTTagCompound();
            newTagCompound.func_74768_a("Energy", 0);
            container.func_77982_d(newTagCompound);
        }
        int energyExtracted = Math.min(this.getInternalEnergyStored(container), Math.min(this.getMaxEnergyStored(container), maxExtract));
        if (!simulate) {
            int stored = this.getInternalEnergyStored(container);
            container.func_77978_p().func_74768_a("Energy", stored -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getSend() {
        return 40;
    }

    public int getReceive() {
        return 0;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getInternalEnergyStored(oldStack) > 0 != this.getInternalEnergyStored(newStack) > 0);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        super.func_77636_d(stack);
        return this.isOn(stack);
    }
}

