/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.common.generators.ItemInventoryGenerator;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInvMagmaticGen
extends ItemInventoryGenerator {
    public ItemInvMagmaticGen() {
        super("inv_magmatic_gen");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.invgens.magmatic"));
        this.addMoreInformation(stack, tooltip);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151129_at);
    }

    @Override
    public int calculateTime(ItemStack stack) {
        return 7500;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        final ModelResourceLocation onModel1 = new ModelResourceLocation(this.getRegistryName() + "_on1", "inventory");
        final ModelResourceLocation onModel2 = new ModelResourceLocation(this.getRegistryName() + "_on2", "inventory");
        final ModelResourceLocation onModel3 = new ModelResourceLocation(this.getRegistryName() + "_on3", "inventory");
        final ModelResourceLocation onModel4 = new ModelResourceLocation(this.getRegistryName() + "_on4", "inventory");
        final ModelResourceLocation onModel5 = new ModelResourceLocation(this.getRegistryName() + "_on5", "inventory");
        final ModelResourceLocation offModel = new ModelResourceLocation(this.getRegistryName() + "_off", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{onModel1, onModel2, onModel3, onModel4, onModel5, offModel});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                int burnTime = ItemInvMagmaticGen.this.getBurnTime(stack);
                if (ItemInvMagmaticGen.this.isOn(stack) && burnTime > 0) {
                    if (burnTime < 1500) {
                        return onModel1;
                    }
                    if (burnTime < 3000) {
                        return onModel2;
                    }
                    if (burnTime < 4500) {
                        return onModel3;
                    }
                    if (burnTime < 6000) {
                        return onModel4;
                    }
                    return onModel5;
                }
                return offModel;
            }
        });
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }
}

