/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.common.generators.ItemInventoryGenerator;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemInvDeathGen
extends ItemInventoryGenerator {
    private Item BONE_BLOCK = Item.func_150898_a((Block)Blocks.field_189880_di);
    private Item[] validItems = new Item[]{Items.field_151103_aS, Items.field_151078_bh, Items.field_151144_bL, this.BONE_BLOCK};
    private ArrayList<Item> validItemsArrayList = new ArrayList<Item>(Arrays.asList(this.validItems));

    public ItemInvDeathGen() {
        super("inv_death_gen");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.invgens.death"));
        this.addMoreInformation(stack, tooltip);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return !stack.func_190926_b() && this.validItemsArrayList.contains(stack.func_77973_b());
    }

    @Override
    public int calculateTime(ItemStack stack) {
        return 400;
    }

    @Override
    public int calculatePower(ItemStack stack) {
        int minSend = 0;
        Item fuel = this.getFuel(stack).func_77973_b();
        if (fuel.equals(Items.field_151144_bL)) {
            minSend = 150;
        } else if (fuel.equals(this.BONE_BLOCK)) {
            minSend = 120;
        } else if (fuel.equals(Items.field_151103_aS)) {
            minSend = 40;
        } else if (fuel.equals(Items.field_151078_bh)) {
            minSend = 20;
        }
        return Math.min(this.getMaxEnergyStored(stack) - this.getInternalEnergyStored(stack), minSend);
    }

    @Override
    public int getSend() {
        return 150;
    }

    @Override
    public void initModel() {
        super.initModel();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }
}

