/*
 * Decompiled with CFR 0.152.
 */
package com.feyberryjam.minecraft.textadventure.command;

import com.feyberryjam.minecraft.textadventure.util.command.CommandHelper;
import com.feyberryjam.minecraft.textadventure.util.text.EnglishHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CommandLook
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public String func_71517_b() {
        return "look";
    }

    public List<String> func_71514_a() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("l");
        return aliases;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.look.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos end;
        BlockPos start;
        Entity entity = sender.func_174793_f();
        if (!(entity instanceof EntityPlayer)) {
            throw new WrongUsageException("commands.general.notplayer", new Object[0]);
        }
        WhatToLookAt lookAt = WhatToLookAt.EVERYTHING;
        if (args.length == 0) {
            CommandHelper.TextToPlayer(sender, ">look");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("at")) {
            args[0] = args[1];
        }
        if (args.length == 1 || args.length == 2) {
            boolean validOneArgument = false;
            if (args[0].equalsIgnoreCase("everything") || args[0].equalsIgnoreCase("all")) {
                CommandHelper.TextToPlayer(sender, ">look");
                validOneArgument = true;
            }
            if (args[0].equalsIgnoreCase("location") || args[0].equalsIgnoreCase("place") || args[0].equalsIgnoreCase("room")) {
                CommandHelper.TextToPlayer(sender, ">look at location");
                lookAt = WhatToLookAt.ROOM;
                validOneArgument = true;
            }
            if (args[0].equalsIgnoreCase("sun") || args[0].equalsIgnoreCase("sky")) {
                CommandHelper.TextToPlayer(sender, ">look at sun");
                lookAt = WhatToLookAt.SUN;
                validOneArgument = true;
            }
            if (args[0].equalsIgnoreCase("items") || args[0].equalsIgnoreCase("item") || args[0].equalsIgnoreCase("i")) {
                CommandHelper.TextToPlayer(sender, ">look at items");
                lookAt = WhatToLookAt.ITEMS;
                validOneArgument = true;
            }
            if (args[0].equalsIgnoreCase("creatures") || args[0].equalsIgnoreCase("mobs") || args[0].equalsIgnoreCase("c")) {
                CommandHelper.TextToPlayer(sender, ">look at creatures");
                lookAt = WhatToLookAt.CREATURES;
                validOneArgument = true;
            }
            if (!validOneArgument) {
                throw new WrongUsageException("commands.look.usage", new Object[0]);
            }
        }
        EntityPlayer player = (EntityPlayer)entity;
        World world = player.func_130014_f_();
        BlockPos playerPosition = player.func_180425_c();
        float lighting = world.func_175724_o(playerPosition);
        for (PotionEffect effect : player.func_70651_bq()) {
            if (effect.func_188419_a() != MobEffects.field_76440_q) continue;
            CommandHelper.TextToPlayer(sender, "commands.look.blind");
            return;
        }
        boolean canSee = true;
        if (lighting <= 0.1f) {
            canSee = false;
        }
        if (lookAt == WhatToLookAt.SUN || lookAt == WhatToLookAt.EVERYTHING) {
            Long time = world.func_72820_D() % 24000L;
            if (!CommandHelper.canReallyReallySeeSky(world, playerPosition)) {
                CommandHelper.TextToPlayer(sender, "The sky is not visible directly above you.");
            } else if (player.field_70163_u < 55.0) {
                if (time >= 22500L || time < 1000L) {
                    CommandHelper.TextToPlayer(sender, "The sky above appears dim.");
                } else if (time >= 1000L && time < 11000L) {
                    CommandHelper.TextToPlayer(sender, "The sun appears to be bright above you.");
                } else if (time >= 11000L && time < 13000L) {
                    CommandHelper.TextToPlayer(sender, "The sky above appears dim.");
                } else if (time >= 13000L && time < 22500L) {
                    CommandHelper.TextToPlayer(sender, "The sun is nowhere to be seen.");
                }
            } else if (time >= 22500L || time < 1000L) {
                CommandHelper.TextToPlayer(sender, "The morning sun is visible off to the east.");
            } else if (time >= 1000L && time < 11000L) {
                CommandHelper.TextToPlayer(sender, "The sun hangs high in the sky.");
                if (lookAt == WhatToLookAt.SUN) {
                    CommandHelper.TextToPlayer(sender, "commands.look.sunbad");
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 250, 1));
                }
            } else if (time >= 11000L && time < 13000L) {
                CommandHelper.TextToPlayer(sender, "It will be night soon...");
            } else if (time >= 13000L && time < 22500L) {
                CommandHelper.TextToPlayer(sender, "It is currently night.");
            }
        }
        if (canSee && (lookAt == WhatToLookAt.EVERYTHING || lookAt == WhatToLookAt.ROOM)) {
            if (player.field_70163_u < 55.0) {
                CommandHelper.TextToPlayer(sender, "You appear to be deep under ground.");
            } else {
                Biome playerBiome = world.func_180494_b(playerPosition);
                String biomeName = "strange and wonderful land";
                Field f = ReflectionHelper.findField(Biome.class, (String[])new String[]{"field_76791_y", "biomeName"});
                f.setAccessible(true);
                try {
                    biomeName = (String)f.get(playerBiome);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                biomeName = biomeName.toLowerCase();
                String string = "Here we have " + EnglishHelper.prefixWithAorAn(biomeName) + ".";
                CommandHelper.TextToPlayer(player, string);
                if (world.func_175727_C(playerPosition)) {
                    CommandHelper.TextToPlayer(player, "commands.look.rainedon");
                }
            }
            Village nearVillage = world.func_175714_ae().func_176056_a(playerPosition, 50);
            if (nearVillage != null) {
                CommandHelper.TextToPlayer(sender, "You are near a village.");
            }
        }
        if (canSee && (lookAt == WhatToLookAt.EVERYTHING || lookAt == WhatToLookAt.CREATURES)) {
            start = playerPosition.func_177982_a(-10, -10, -10);
            end = playerPosition.func_177982_a(10, 10, 10);
            List listEL = world.func_72872_a(EntityLiving.class, new AxisAlignedBB(start, end));
            boolean firstSeen = true;
            if (listEL.size() > 0) {
                for (EntityLiving el : listEL) {
                    if (!player.func_70685_l((Entity)el)) continue;
                    if (firstSeen) {
                        firstSeen = false;
                        CommandHelper.TextToPlayer(sender, "There are creatures nearby:");
                    }
                    CommandHelper.TextToPlayer(sender, "   " + el.func_145748_c_().func_150260_c());
                }
            }
            if (lookAt == WhatToLookAt.CREATURES && firstSeen) {
                CommandHelper.TextToPlayer(sender, "You see no nearby creatures.");
            }
        }
        if (canSee && (lookAt == WhatToLookAt.EVERYTHING || lookAt == WhatToLookAt.ITEMS)) {
            start = playerPosition.func_177982_a(-10, -10, -10);
            end = playerPosition.func_177982_a(10, 10, 10);
            List listEI = world.func_72872_a(EntityItem.class, new AxisAlignedBB(start, end));
            boolean firstSeen = true;
            if (listEI.size() > 0) {
                for (EntityItem ei : listEI) {
                    if (!player.func_70685_l((Entity)ei)) continue;
                    if (firstSeen) {
                        firstSeen = false;
                        CommandHelper.TextToPlayer(sender, "There are items nearby:");
                    }
                    CommandHelper.TextToPlayer(sender, "   " + ei.func_92059_d().func_82833_r());
                }
            }
            if (lookAt == WhatToLookAt.ITEMS && firstSeen) {
                CommandHelper.TextToPlayer(sender, "You see no nearby items.");
            }
        }
        if (!canSee) {
            CommandHelper.TextToPlayer(sender, "You are unable to see much around you without more light.");
        }
        if (lighting <= 0.18f) {
            String tempString = "It's very dark here";
            tempString = lighting <= 0.05f ? tempString + "!\nJust the way grues like it." : tempString + ".";
            CommandHelper.TextToPlayer(player, tempString);
        }
    }

    public static enum WhatToLookAt {
        EVERYTHING,
        ROOM,
        SUN,
        CREATURES,
        ITEMS;

    }
}

