/*
 * Decompiled with CFR 0.152.
 */
package com.feyberryjam.minecraft.textadventure.capabilities;

import com.feyberryjam.minecraft.textadventure.capabilities.IReceivedJoinMessage;
import com.feyberryjam.minecraft.textadventure.capabilities.ProviderReceivedJoinMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class CapabilityEvents {
    public static final ResourceLocation CAP_ReceivedJoinMessage = new ResourceLocation("textadventure", "receivedjoinmessage");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        EntityLivingBase entity;
        if (CapabilityEvents.canHaveAttributes((Entity)event.getObject()) && (entity = (EntityLivingBase)event.getObject()) instanceof EntityPlayer) {
            event.addCapability(CAP_ReceivedJoinMessage, (ICapabilityProvider)new ProviderReceivedJoinMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        IReceivedJoinMessage receivedJoinMessage = (IReceivedJoinMessage)player.getCapability(ProviderReceivedJoinMessage.CAP_ReceivedJoinMessage, null);
        IReceivedJoinMessage oldReceivedJoinMessage = (IReceivedJoinMessage)event.getOriginal().getCapability(ProviderReceivedJoinMessage.CAP_ReceivedJoinMessage, null);
        receivedJoinMessage.set(oldReceivedJoinMessage.get());
    }

    public static boolean canHaveAttributes(Entity entity) {
        return entity instanceof EntityLivingBase;
    }

    public static boolean canHaveAttributes(Item item) {
        return item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemBow || item instanceof ItemArmor || item instanceof ItemShield;
    }
}

