/*
 * Decompiled with CFR 0.152.
 */
package com.nic.st.util;

import com.nic.st.blocks.BlockBlueprintCreator;
import com.nic.st.blocks.BlockHologram;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Utils {
    public static void placeVoxels(World w, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockBlueprintCreator.TileEntityBlueprintCreator> creators = new ArrayList<BlockBlueprintCreator.TileEntityBlueprintCreator>();
        if (w.func_175625_s(pos.func_177977_b()) instanceof BlockBlueprintCreator.TileEntityBlueprintCreator) {
            creators.add((BlockBlueprintCreator.TileEntityBlueprintCreator)w.func_175625_s(pos.func_177977_b()));
        }
        Vec3d hitVec = player.func_174824_e(0.0f);
        Vec3d lookPos = player.func_70676_i(0.0f);
        hitVec = hitVec.func_72441_c(lookPos.field_72450_a * 5.0, lookPos.field_72448_b * 5.0, lookPos.field_72449_c * 5.0);
        for (BlockBlueprintCreator.TileEntityBlueprintCreator creator : creators) {
            int voxel = Utils.getEmptyVoxel(BlockHologram.HOLO_BOX.func_186670_a(creator.func_174877_v()), player.func_174824_e(0.0f), hitVec, creator.voxels, creator.func_174877_v());
            if (voxel != -1) {
                creator.voxels[voxel] = (byte)(creator.buttonDown + 1);
            }
            creator.func_70296_d();
            IBlockState state = creator.func_145831_w().func_180495_p(creator.func_174877_v());
            creator.func_145831_w().func_184138_a(creator.func_174877_v(), state, state, 3);
        }
    }

    public static void breakVoxels(World w, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockBlueprintCreator.TileEntityBlueprintCreator> creators = new ArrayList<BlockBlueprintCreator.TileEntityBlueprintCreator>();
        if (w.func_175625_s(pos.func_177977_b()) instanceof BlockBlueprintCreator.TileEntityBlueprintCreator) {
            creators.add((BlockBlueprintCreator.TileEntityBlueprintCreator)w.func_175625_s(pos.func_177977_b()));
        }
        if (w.func_175625_s(pos.func_177977_b().func_177978_c()) instanceof BlockBlueprintCreator.TileEntityBlueprintCreator) {
            creators.add((BlockBlueprintCreator.TileEntityBlueprintCreator)w.func_175625_s(pos.func_177977_b().func_177978_c()));
        }
        if (w.func_175625_s(pos.func_177977_b().func_177968_d()) instanceof BlockBlueprintCreator.TileEntityBlueprintCreator) {
            creators.add((BlockBlueprintCreator.TileEntityBlueprintCreator)w.func_175625_s(pos.func_177977_b().func_177968_d()));
        }
        Vec3d hitVec = player.func_174824_e(0.0f);
        Vec3d lookPos = player.func_70676_i(0.0f);
        hitVec = hitVec.func_72441_c(lookPos.field_72450_a * 5.0, lookPos.field_72448_b * 5.0, lookPos.field_72449_c * 5.0);
        for (BlockBlueprintCreator.TileEntityBlueprintCreator creator : creators) {
            int voxel = Utils.getVoxel(BlockHologram.HOLO_BOX.func_186670_a(creator.func_174877_v()), player.func_174824_e(0.0f), hitVec, creator.voxels, creator.func_174877_v());
            if (voxel != -1) {
                creator.voxels[voxel] = 0;
            }
            creator.func_70296_d();
            IBlockState state = creator.func_145831_w().func_180495_p(creator.func_174877_v());
            creator.func_145831_w().func_184138_a(creator.func_174877_v(), state, state, 3);
        }
    }

    public static int getVoxel(AxisAlignedBB bb, Vec3d origin, Vec3d end, byte[] voxels, BlockPos pos) {
        RayTraceResult result = Utils.calculateFarthestIntercept(bb, origin, end);
        if (result == null) {
            return -1;
        }
        AxisAlignedBB voxel = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 0.0625, 0.0625);
        Vec3d closest = null;
        int closestIndex = -1;
        int i = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        while (i < voxels.length) {
            AxisAlignedBB current;
            RayTraceResult currentResult;
            if (voxels[i] != 0 && (currentResult = (current = voxel.func_72317_d((double)pos.func_177958_n() + (double)x * 0.0625 + 0.25, (double)pos.func_177956_o() + 1.5 + (double)y * 0.0625, (double)pos.func_177952_p() + (double)z * 0.0625)).func_72327_a(origin, end)) != null && Utils.compare(origin, closest, currentResult.field_72307_f) <= 0) {
                closest = currentResult.field_72307_f;
                closestIndex = i;
            }
            x = ++i % 8;
            y = i % 64 / 8;
            z = i / 64;
        }
        return closestIndex;
    }

    private static RayTraceResult calculateFarthestIntercept(AxisAlignedBB bb, Vec3d origin, Vec3d end) {
        Vec3d vec3d = Utils.collideWithXPlane(bb, bb.field_72340_a, origin, end);
        EnumFacing enumfacing = EnumFacing.WEST;
        Vec3d vec3d1 = Utils.collideWithXPlane(bb, bb.field_72336_d, origin, end);
        if (vec3d1 != null && Utils.compare(origin, vec3d, vec3d1) >= 0) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.EAST;
        }
        if ((vec3d1 = Utils.collideWithYPlane(bb, bb.field_72338_b, origin, end)) != null && Utils.compare(origin, vec3d, vec3d1) >= 0) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.DOWN;
        }
        if ((vec3d1 = Utils.collideWithYPlane(bb, bb.field_72337_e, origin, end)) != null && Utils.compare(origin, vec3d, vec3d1) >= 0) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.UP;
        }
        if ((vec3d1 = Utils.collideWithZPlane(bb, bb.field_72339_c, origin, end)) != null && Utils.compare(origin, vec3d, vec3d1) >= 0) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.NORTH;
        }
        if ((vec3d1 = Utils.collideWithZPlane(bb, bb.field_72334_f, origin, end)) != null && Utils.compare(origin, vec3d, vec3d1) >= 0) {
            vec3d = vec3d1;
            enumfacing = EnumFacing.SOUTH;
        }
        return vec3d == null ? null : new RayTraceResult(vec3d, enumfacing);
    }

    private static Vec3d collideWithXPlane(AxisAlignedBB bb, double p_186671_1_, Vec3d p_186671_3_, Vec3d p_186671_4_) {
        Vec3d vec3d = p_186671_3_.func_72429_b(p_186671_4_, p_186671_1_);
        return vec3d != null && vec3d.field_72448_b >= bb.field_72338_b && vec3d.field_72448_b <= bb.field_72337_e && vec3d.field_72449_c >= bb.field_72339_c && vec3d.field_72449_c <= bb.field_72334_f ? vec3d : null;
    }

    private static Vec3d collideWithYPlane(AxisAlignedBB bb, double p_186663_1_, Vec3d p_186663_3_, Vec3d p_186663_4_) {
        Vec3d vec3d = p_186663_3_.func_72435_c(p_186663_4_, p_186663_1_);
        return vec3d != null && vec3d.field_72450_a >= bb.field_72340_a && vec3d.field_72450_a <= bb.field_72336_d && vec3d.field_72449_c >= bb.field_72339_c && vec3d.field_72449_c <= bb.field_72334_f ? vec3d : null;
    }

    private static Vec3d collideWithZPlane(AxisAlignedBB bb, double p_186665_1_, Vec3d p_186665_3_, Vec3d p_186665_4_) {
        Vec3d vec3d = p_186665_3_.func_72434_d(p_186665_4_, p_186665_1_);
        return vec3d != null && vec3d.field_72450_a >= bb.field_72340_a && vec3d.field_72450_a <= bb.field_72336_d && vec3d.field_72448_b >= bb.field_72338_b && vec3d.field_72448_b <= bb.field_72337_e ? vec3d : null;
    }

    private static int compare(Vec3d origin, @Nullable Vec3d current, Vec3d checking) {
        return current == null ? 0 : (origin.func_72436_e(checking) > origin.func_72436_e(current) ? 1 : -1);
    }

    private static int getEmptyVoxel(AxisAlignedBB bb, Vec3d origin, Vec3d end, byte[] voxels, BlockPos pos) {
        if (Utils.calculateFarthestIntercept(bb, origin, end) == null) {
            return -1;
        }
        AxisAlignedBB voxel = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 0.0625, 0.0625);
        RayTraceResult closestVoxel = null;
        int i = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        while (i < voxels.length) {
            RayTraceResult cvResult;
            AxisAlignedBB voxelPos = voxel.func_72317_d((double)pos.func_177958_n() + (double)x * 0.0625 + 0.25, (double)pos.func_177956_o() + 1.5 + (double)y * 0.0625, (double)pos.func_177952_p() + (double)z * 0.0625);
            if (voxels[i] != 0 && (cvResult = voxelPos.func_72327_a(origin, end)) != null && Utils.compare(origin, closestVoxel == null ? null : closestVoxel.field_72307_f, cvResult.field_72307_f) <= 0) {
                closestVoxel = cvResult;
            }
            x = ++i % 8;
            y = i % 64 / 8;
            z = i / 64;
        }
        RayTraceResult farthestEmptyVoxel = null;
        int farthestEmptyIndex = -1;
        int i2 = 0;
        int x2 = 0;
        int y2 = 0;
        int z2 = 0;
        while (i2 < voxels.length) {
            RayTraceResult fvResult;
            AxisAlignedBB voxelPos = voxel.func_72317_d((double)pos.func_177958_n() + (double)x2 * 0.0625 + 0.25, (double)pos.func_177956_o() + 1.5 + (double)y2 * 0.0625, (double)pos.func_177952_p() + (double)z2 * 0.0625);
            if (voxels[i2] == 0 && (fvResult = voxelPos.func_72327_a(origin, end)) != null && Utils.compare(origin, closestVoxel == null ? null : closestVoxel.field_72307_f, fvResult.field_72307_f) <= 0 && Utils.compare(origin, farthestEmptyVoxel == null ? null : farthestEmptyVoxel.field_72307_f, fvResult.field_72307_f) >= 0) {
                farthestEmptyVoxel = fvResult;
                farthestEmptyIndex = i2;
            }
            x2 = ++i2 % 8;
            y2 = i2 % 64 / 8;
            z2 = i2 / 64;
        }
        return farthestEmptyIndex;
    }
}

