/*
 * Decompiled with CFR 0.152.
 */
package com.nic.st.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LimbManipulationUtil {
    private static Field textureOffsetXField = ModelRenderer.class.getDeclaredFields()[2];
    private static Field textureOffsetYField = ModelRenderer.class.getDeclaredFields()[3];

    public static LimbManipulator getLimbManipulator(RenderPlayer renderPlayer, Limb limb) {
        LimbManipulator manipulator = new LimbManipulator();
        try {
            textureOffsetXField.setAccessible(true);
            textureOffsetYField.setAccessible(true);
            List layerList = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)renderPlayer, (int)4);
            for (LayerRenderer layer : layerList) {
                for (Field field : layer.getClass().getDeclaredFields()) {
                    ModelRenderer modelRenderer;
                    ModelBiped model;
                    field.setAccessible(true);
                    if (field.getType() == ModelBiped.class) {
                        model = (ModelBiped)field.get(layer);
                        modelRenderer = (ModelRenderer)limb.rendererField.get(model);
                        manipulator.limbs.add(new CustomModelRenderer(model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.rendererField));
                        if (limb != Limb.HEAD) continue;
                        modelRenderer = (ModelRenderer)limb.secondaryRendererField.get(model);
                        manipulator.limbs.add(new CustomModelRenderer(model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.secondaryRendererField));
                        continue;
                    }
                    if (field.getType() != ModelPlayer.class) continue;
                    model = (ModelBiped)field.get(layer);
                    modelRenderer = (ModelRenderer)limb.rendererField.get(model);
                    manipulator.limbs.add(new CustomModelRenderer(model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.rendererField));
                    modelRenderer = (ModelRenderer)limb.secondaryRendererField.get(model);
                    manipulator.limbs.add(new CustomModelRenderer(model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.secondaryRendererField));
                }
            }
            ModelPlayer model = renderPlayer.func_177087_b();
            ModelRenderer modelRenderer = (ModelRenderer)limb.rendererField.get(model);
            manipulator.limbs.add(new CustomModelRenderer((ModelBiped)model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.rendererField));
            modelRenderer = (ModelRenderer)limb.secondaryRendererField.get(model);
            manipulator.limbs.add(new CustomModelRenderer((ModelBiped)model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.secondaryRendererField));
            textureOffsetXField.setAccessible(false);
            textureOffsetYField.setAccessible(false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return manipulator;
    }

    public static LimbManipulator getLimbManipulator(ModelPlayer model, Limb limb) {
        LimbManipulator manipulator = new LimbManipulator();
        try {
            textureOffsetXField.setAccessible(true);
            textureOffsetYField.setAccessible(true);
            ModelRenderer modelRenderer = (ModelRenderer)limb.rendererField.get(model);
            manipulator.limbs.add(new CustomModelRenderer((ModelBiped)model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.rendererField));
            modelRenderer = (ModelRenderer)limb.secondaryRendererField.get(model);
            manipulator.limbs.add(new CustomModelRenderer((ModelBiped)model, textureOffsetXField.getInt(modelRenderer), textureOffsetYField.getInt(modelRenderer), modelRenderer, limb.secondaryRendererField));
            textureOffsetXField.setAccessible(false);
            textureOffsetYField.setAccessible(false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return manipulator;
    }

    public static float interpolateRotation(float prev, float current, float partialTicks) {
        float f;
        for (f = current - prev; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prev + partialTicks * f;
    }

    public static class CustomModelRenderer
    extends ModelRenderer {
        private float actualX;
        private float actualY;
        private float actualZ;
        private float offX;
        private float offY;
        private float offZ;
        private boolean changeAngles = false;
        private ModelBiped modelBiped;
        private ModelRenderer old;
        private Field f;

        private CustomModelRenderer(ModelBiped model, int texOffX, int texOffY, ModelRenderer old, Field field) throws IllegalAccessException {
            super((ModelBase)model, "");
            this.modelBiped = model;
            this.old = old;
            this.func_78784_a(texOffX, texOffY);
            this.f = field;
            this.field_78804_l = old.field_78804_l;
            this.func_78793_a(old.field_78800_c, old.field_78797_d, old.field_78798_e);
            field.set(model, (Object)this);
        }

        public void func_78785_a(float scale) {
            if (this.changeAngles) {
                this.field_78795_f = this.actualX;
                this.field_78796_g = this.actualY;
                this.field_78808_h = this.actualZ;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)this.offX, (float)this.offY, (float)this.offZ);
            GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)(-this.field_78800_c * scale), (float)(-this.field_78797_d * scale), (float)(-this.field_78798_e * scale));
            super.func_78785_a(scale);
            GlStateManager.func_179121_F();
        }

        public void reset() {
            if (this.f != null) {
                try {
                    this.f.set(this.modelBiped, this.old);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        private void setAnglesRadians(float x, float y, float z) {
            this.actualX = x;
            this.actualY = y;
            this.actualZ = z;
            this.changeAngles = true;
        }

        private void setAngles(float x, float y, float z) {
            this.setAnglesRadians((float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
        }

        private void setOffsets(float x, float y, float z) {
            this.offX = x;
            this.offY = y;
            this.offZ = z;
        }
    }

    public static class LimbManipulator {
        private ArrayList<CustomModelRenderer> limbs = new ArrayList();

        public LimbManipulator setAngles(float x, float y, float z) {
            for (CustomModelRenderer limb : this.limbs) {
                limb.setAngles(x, y, z);
            }
            return this;
        }

        public LimbManipulator setOffsets(float x, float y, float z) {
            for (CustomModelRenderer limb : this.limbs) {
                limb.setOffsets(x, y, z);
            }
            return this;
        }
    }

    public static enum Limb {
        HEAD(ModelBiped.class.getDeclaredFields()[0], ModelBiped.class.getDeclaredFields()[1]),
        BODY(ModelBiped.class.getDeclaredFields()[2], ModelPlayer.class.getDeclaredFields()[4]),
        LEFT_ARM(ModelBiped.class.getDeclaredFields()[4], ModelPlayer.class.getDeclaredFields()[0]),
        RIGHT_ARM(ModelBiped.class.getDeclaredFields()[3], ModelPlayer.class.getDeclaredFields()[1]),
        LEFT_LEG(ModelBiped.class.getDeclaredFields()[6], ModelPlayer.class.getDeclaredFields()[2]),
        RIGHT_LEG(ModelBiped.class.getDeclaredFields()[5], ModelPlayer.class.getDeclaredFields()[3]);

        public Field rendererField;
        public Field secondaryRendererField;

        private Limb(Field rendererField, Field secondaryRendererField) {
            this.rendererField = rendererField;
            this.secondaryRendererField = secondaryRendererField;
        }
    }
}

