/*
 * Decompiled with CFR 0.152.
 */
package com.nic.st.items;

import com.nic.st.StarTech;
import com.nic.st.entity.EntityBullet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemPrintedGun
extends Item {
    public ItemPrintedGun() {
        this.setRegistryName("star-tech", "printed_gun");
        this.func_77655_b("printed_gun");
        this.func_77625_d(1);
    }

    public static NBTTagCompound getGunData(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74773_a("voxels", new byte[1024]);
            nbt.func_74768_a("fire_freq", -1);
            nbt.func_74768_a("fireCount", 0);
            nbt.func_74768_a("max_ammo", -1);
            nbt.func_74768_a("ammo", -1);
            nbt.func_74780_a("damage", -1.0);
            stack.func_77982_d(nbt);
        }
        return stack.func_77978_p();
    }

    public static NBTTagCompound createGunData(byte[] voxels, ItemStack stack) {
        NBTTagCompound nbt = ItemPrintedGun.getGunData(stack);
        int yellow = 0;
        double darkGrey = 0.0;
        double lightGrey = 0.0;
        int blue = 0;
        block7: for (byte voxel : voxels) {
            switch (voxel) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    ++yellow;
                    continue block7;
                }
                case 2: {
                    darkGrey += 1.0;
                    continue block7;
                }
                case 3: {
                    lightGrey += 1.0;
                    continue block7;
                }
                case 4: {
                    ++blue;
                }
            }
        }
        if (yellow > 20) {
            yellow = 20;
        }
        if (blue > 20) {
            blue = 20;
        }
        nbt.func_74773_a("voxels", voxels);
        nbt.func_74768_a("fire_freq", 40 - yellow * 2);
        nbt.func_74768_a("max_ammo", blue * 250);
        nbt.func_74768_a("ammo", blue * 250);
        nbt.func_74780_a("damage", darkGrey / lightGrey);
        return nbt;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        EnumHand oppositeHand;
        EnumHand enumHand = oppositeHand = EnumHand.MAIN_HAND == handIn ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        if (player.func_184586_b(oppositeHand).func_77973_b() instanceof ItemPrintedGun) {
            this.shoot(worldIn, player, oppositeHand);
        }
        return this.shoot(worldIn, player, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound gunData = ItemPrintedGun.getGunData(stack);
        if (gunData.func_74762_e("fireCount") < gunData.func_74762_e("fire_freq")) {
            gunData.func_74768_a("fireCount", gunData.func_74762_e("fireCount") + 1);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    private ActionResult<ItemStack> shoot(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        NBTTagCompound gunData = ItemPrintedGun.getGunData(itemstack);
        if (gunData.func_74762_e("ammo") <= 0 && !this.reload(player, itemstack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (gunData.func_74762_e("fireCount") < gunData.func_74762_e("fire_freq")) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        gunData.func_74768_a("fireCount", 0);
        gunData.func_74768_a("ammo", gunData.func_74762_e("ammo") - (int)(gunData.func_74769_h("damage") * 20.0));
        if (!worldIn.field_72995_K) {
            EnumHandSide side = player.func_184591_cq() == EnumHandSide.RIGHT ? (handIn == EnumHand.MAIN_HAND ? EnumHandSide.RIGHT : EnumHandSide.LEFT) : (handIn == EnumHand.MAIN_HAND ? EnumHandSide.LEFT : EnumHandSide.RIGHT);
            Vec3d eyes = player.func_174824_e(0.0f);
            Vec3d rotVec = this.getVectorForRotation(player.field_70125_A, side == EnumHandSide.RIGHT ? player.field_70177_z + 90.0f : player.field_70177_z - 90.0f);
            Vec3d offset = eyes.func_178787_e(rotVec.func_186678_a(0.3)).func_178786_a(0.0, 0.1, 0.0);
            EntityBullet entityBullet = new EntityBullet(worldIn, (EntityLivingBase)player);
            entityBullet.damage = gunData.func_74769_h("damage");
            entityBullet.func_70012_b(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c, entityBullet.field_70177_z, entityBullet.field_70125_A);
            entityBullet.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_72838_d((Entity)entityBullet);
            worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, StarTech.Sounds.shoot, SoundCategory.PLAYERS, 1.0f, new Random().nextFloat());
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    private boolean reload(EntityPlayer player, ItemStack stack) {
        NBTTagCompound gunData = ItemPrintedGun.getGunData(stack);
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (itemStack.func_77973_b() == Items.field_151137_ax) {
                if (gunData.func_74762_e("ammo") < gunData.func_74762_e("max_ammo")) {
                    gunData.func_74768_a("ammo", Math.min(gunData.func_74762_e("ammo20"), gunData.func_74762_e("max_ammo")));
                } else {
                    return true;
                }
            }
            if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
                if (gunData.func_74762_e("ammo") < gunData.func_74762_e("max_ammo")) {
                    gunData.func_74768_a("ammo", Math.min(gunData.func_74762_e("ammo180"), gunData.func_74762_e("max_ammo")));
                } else {
                    return true;
                }
            }
            if (itemStack.func_77973_b() == Items.field_151016_H) {
                if (gunData.func_74762_e("ammo") < gunData.func_74762_e("max_ammo")) {
                    gunData.func_74768_a("ammo", Math.min(gunData.func_74762_e("ammo40"), gunData.func_74762_e("max_ammo")));
                } else {
                    return true;
                }
            }
            if (itemStack.func_77973_b() == Items.field_151114_aO) {
                if (gunData.func_74762_e("ammo") < gunData.func_74762_e("max_ammo")) {
                    gunData.func_74768_a("ammo", Math.min(gunData.func_74762_e("ammo40"), gunData.func_74762_e("max_ammo")));
                } else {
                    return true;
                }
            }
            if (itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150426_aN)) continue;
            if (gunData.func_74762_e("ammo") < gunData.func_74762_e("max_ammo")) {
                gunData.func_74768_a("ammo", Math.min(gunData.func_74762_e("ammo160"), gunData.func_74762_e("max_ammo")));
                continue;
            }
            return true;
        }
        return gunData.func_74762_e("ammo") > 0;
    }

    private Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }
}

