/*
 * Decompiled with CFR 0.152.
 */
package com.nic.st;

import com.nic.st.CommonProxy;
import com.nic.st.blocks.BlockBlueprintCreator;
import com.nic.st.blocks.BlockHologram;
import com.nic.st.blocks.BlockPrinter;
import com.nic.st.entity.EntityBullet;
import com.nic.st.items.ItemBlueprint;
import com.nic.st.items.ItemPrintedGun;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="star-tech", name="Star Tech, Man! The Legendary Mod?", version="1.0", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class StarTech {
    public static final String MODID = "star-tech";
    public static final String NAME = "Star Tech, Man! The Legendary Mod?";
    public static final String VERSION = "1.0";
    @SidedProxy(clientSide="com.nic.st.ClientProxy", serverSide="com.nic.st.CommonProxy")
    public static CommonProxy proxy;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BlockBlueprintCreator());
        event.getRegistry().register((IForgeRegistryEntry)new BlockHologram());
        event.getRegistry().register((IForgeRegistryEntry)new BlockPrinter());
    }

    @SubscribeEvent
    public static void registerEntityEntry(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntityBullet.class).id(new ResourceLocation(MODID, "bullet"), 0).name("bullet").tracker(80, 10, true).build());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) throws IllegalAccessException {
        event.getRegistry().register((IForgeRegistryEntry)new ItemPrintedGun());
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlueprint());
        for (Field field : Blocks.class.getDeclaredFields()) {
            Block block = (Block)field.get(null);
            Item itemBlock = ((Item)new ItemBlock(block).setRegistryName(block.getRegistryName())).func_77655_b(block.func_149739_a());
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        Sounds.shoot = (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "shoot")).setRegistryName(MODID, "shoot");
        event.getRegistry().register((IForgeRegistryEntry)Sounds.shoot);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(BlockBlueprintCreator.TileEntityBlueprintCreator.class, (String)"star-tech:blueprint_creator");
        GameRegistry.registerTileEntity(BlockPrinter.TileEntityPrinter.class, (String)"star-tech:printer");
    }

    @Mod.EventHandler
    public void init(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    public static class Sounds {
        public static SoundEvent shoot = null;
    }

    @GameRegistry.ObjectHolder(value="star-tech")
    public static class Items {
        @GameRegistry.ObjectHolder(value="printed_gun")
        public static final Item printedGun = null;
        @GameRegistry.ObjectHolder(value="blueprint_creator")
        public static final Item blueprintCreator = null;
        public static final Item blueprint = null;
    }

    @GameRegistry.ObjectHolder(value="star-tech")
    public static class Blocks {
        @GameRegistry.ObjectHolder(value="blueprint_creator")
        public static final Block blueprintCreator = null;
        public static final Block hologram = null;
        @OBJ
        public static final Block printer = null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OBJ {
    }
}

