/*
 * Decompiled with CFR 0.152.
 */
package com.nic.st;

import com.nic.st.CommonProxy;
import com.nic.st.StarTech;
import com.nic.st.blocks.BlockBlueprintCreator;
import com.nic.st.blocks.BlockHologram;
import com.nic.st.blocks.BlockPrinter;
import com.nic.st.client.BlueprintCreatorRenderer;
import com.nic.st.client.BulletRenderer;
import com.nic.st.client.PrintedGunModel;
import com.nic.st.client.PrinterRenderer;
import com.nic.st.entity.EntityBullet;
import com.nic.st.items.ItemPrintedGun;
import com.nic.st.util.LimbManipulationUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ClientProxy
extends CommonProxy {
    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        RenderLivingBase renderer = (RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)event.getEntityPlayer());
        List layerList = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)renderer, (int)4);
        try {
            for (LayerRenderer layer : layerList) {
                for (Field field : layer.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (field.getType() == ModelBiped.class) {
                        for (ModelRenderer modelRenderer : ((ModelBiped)field.get((Object)layer)).field_78092_r) {
                            if (!(modelRenderer instanceof LimbManipulationUtil.CustomModelRenderer)) continue;
                            ((LimbManipulationUtil.CustomModelRenderer)modelRenderer).reset();
                        }
                        continue;
                    }
                    if (field.getType() != ModelPlayer.class) continue;
                    for (ModelRenderer modelRenderer : ((ModelBiped)field.get((Object)layer)).field_78092_r) {
                        if (!(modelRenderer instanceof LimbManipulationUtil.CustomModelRenderer)) continue;
                        ((LimbManipulationUtil.CustomModelRenderer)modelRenderer).reset();
                    }
                }
            }
            for (ModelRenderer modelRenderer : event.getRenderer().func_177087_b().field_78092_r) {
                if (!(modelRenderer instanceof LimbManipulationUtil.CustomModelRenderer)) continue;
                ((LimbManipulationUtil.CustomModelRenderer)modelRenderer).reset();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new PrintedGunModel.PrintedGunModelLoader());
        RenderingRegistry.registerEntityRenderingHandler(EntityBullet.class, BulletRenderer::new);
        OBJLoader.INSTANCE.addDomain("star-tech");
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(BlockBlueprintCreator.TileEntityBlueprintCreator.class, (TileEntitySpecialRenderer)new BlueprintCreatorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(BlockPrinter.TileEntityPrinter.class, (TileEntitySpecialRenderer)new PrinterRenderer());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)StarTech.Blocks.blueprintCreator), (int)0, BlockBlueprintCreator.TileEntityBlueprintCreator.class);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent ev) {
        for (Field f : StarTech.Items.class.getDeclaredFields()) {
            try {
                Item item = (Item)f.get(null);
                ModelResourceLocation loc = new ModelResourceLocation(item.getRegistryName(), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)loc);
            }
            catch (ClassCastException | IllegalAccessException e) {
                throw new RuntimeException("Incorrect field in item sub-class", e);
            }
        }
        for (Field f : StarTech.Blocks.class.getDeclaredFields()) {
            try {
                Block block = (Block)f.get(null);
                Item item = Item.func_150898_a((Block)block);
                ModelResourceLocation loc = new ModelResourceLocation(item.getRegistryName() + (f.isAnnotationPresent(StarTech.OBJ.class) ? ".obj" : ""), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)loc);
            }
            catch (ClassCastException | IllegalAccessException e) {
                throw new RuntimeException("Incorrect field in item sub-class", e);
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        ArrayList<LimbManipulationUtil.Limb> limbs = new ArrayList<LimbManipulationUtil.Limb>();
        float f = LimbManipulationUtil.interpolateRotation(player.field_70760_ar, player.field_70761_aq, event.getPartialRenderTick());
        float f1 = LimbManipulationUtil.interpolateRotation(player.field_70758_at, player.field_70759_as, event.getPartialRenderTick());
        float f2 = f1 - f;
        if (player.func_184614_ca().func_77973_b() instanceof ItemPrintedGun) {
            limbs.add(event.getEntityPlayer().func_184591_cq() == EnumHandSide.RIGHT ? LimbManipulationUtil.Limb.RIGHT_ARM : LimbManipulationUtil.Limb.LEFT_ARM);
        }
        if (player.func_184592_cb().func_77973_b() instanceof ItemPrintedGun) {
            limbs.add(event.getEntityPlayer().func_184591_cq() != EnumHandSide.RIGHT ? LimbManipulationUtil.Limb.RIGHT_ARM : LimbManipulationUtil.Limb.LEFT_ARM);
        }
        for (LimbManipulationUtil.Limb limb : limbs) {
            LimbManipulationUtil.getLimbManipulator(event.getRenderer(), limb).setAngles(event.getEntityPlayer().field_70125_A - 90.0f, f2, 0.0f);
        }
    }

    @SubscribeEvent
    public void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        if (event.getTarget().func_178782_a() != null && event.getPlayer().field_70170_p.func_180495_p(event.getTarget().func_178782_a()).func_177230_c() instanceof BlockHologram) {
            event.setCanceled(true);
        }
    }
}

