/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs.proxy;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import selim.modjam.packs.ModConfig;
import selim.modjam.packs.ModJamPacks;
import selim.modjam.packs.PacksItems;
import selim.modjam.packs.capabilities.CapabilityBackpackHandler;
import selim.modjam.packs.network.MessageOpenBackpack;
import selim.modjam.packs.network.MessageOpenUpgrades;
import selim.modjam.packs.proxy.CommonProxy;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final KeyBinding openBackpack = new KeyBinding("key.selimpacks:open_backpack", 34, "key.selimpacks.category");
    public static final KeyBinding openUpgrades = new KeyBinding("key.selimpacks:open_upgrades", 35, "key.selimpacks.category");

    @Override
    public void registerKeybinds() {
        ClientRegistry.registerKeyBinding((KeyBinding)openBackpack);
        ClientRegistry.registerKeyBinding((KeyBinding)openUpgrades);
    }

    @Override
    public void registerEventListeners() {
        super.registerEventListeners();
        MinecraftForge.EVENT_BUS.register(ModConfig.EventHandler.class);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onEvent(InputEvent.KeyInputEvent event) {
        ItemStack stack;
        EntityPlayerSP player;
        if (openBackpack.func_151468_f()) {
            player = Minecraft.func_71410_x().field_71439_g;
            stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY, null)) {
                return;
            }
            ModJamPacks.network.sendToServer((IMessage)new MessageOpenBackpack());
        }
        if (openUpgrades.func_151468_f()) {
            player = Minecraft.func_71410_x().field_71439_g;
            stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY, null)) {
                return;
            }
            ModJamPacks.network.sendToServer((IMessage)new MessageOpenUpgrades());
        }
    }

    @Override
    public IThreadListener getThreadListener(MessageContext context) {
        if (context.side.isClient()) {
            return Minecraft.func_71410_x();
        }
        return context.getServerHandler().field_147369_b.field_71133_b;
    }

    @Override
    public EntityPlayer getPlayer(MessageContext context) {
        if (context == null || context.side.isClient()) {
            return Minecraft.func_71410_x().field_71439_g;
        }
        return context.getServerHandler().field_147369_b;
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        Class<PacksItems> clazz = PacksItems.class;
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (Field f : fields) {
                Object obj = f.get(null);
                if (obj == null || obj == Items.field_190931_a) continue;
                if (obj instanceof Item) {
                    ClientProxy.registerModel((Item)obj);
                    continue;
                }
                System.out.println("Failed to register: " + f.getName());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ModJamPacks.LOGGER.error("An " + e.getClass().getName() + " was thrown when attempting to load Item models.");
            e.printStackTrace();
        }
    }

    private static void registerModel(Item item) {
        if (item == null) {
            return;
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }
}

