/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import selim.modjam.packs.ModJamPacks;

public abstract class MessageUpdateContainerCapability<HANDLER, DATA>
implements IMessage {
    protected final Capability<HANDLER> capability;
    @Nullable
    EnumFacing facing;
    int windowID;
    int slotNumber;
    DATA capabilityData;

    protected MessageUpdateContainerCapability(Capability<HANDLER> capability) {
        this.capability = capability;
    }

    protected MessageUpdateContainerCapability(Capability<HANDLER> capability, @Nullable EnumFacing facing, int windowID, int slotNumber, HANDLER handler) {
        this.capability = capability;
        this.facing = facing;
        this.windowID = windowID;
        this.slotNumber = slotNumber;
        this.capabilityData = this.convertCapabilityToData(handler);
    }

    public final void fromBytes(ByteBuf buf) {
        this.windowID = buf.readInt();
        this.slotNumber = buf.readInt();
        byte facingIndex = buf.readByte();
        this.facing = facingIndex >= 0 ? EnumFacing.func_82600_a((int)facingIndex) : null;
        boolean hasData = buf.readBoolean();
        if (hasData) {
            this.capabilityData = this.readCapabilityData(buf);
        }
    }

    public final void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowID);
        buf.writeInt(this.slotNumber);
        if (this.facing != null) {
            buf.writeByte(this.facing.func_176745_a());
        } else {
            buf.writeByte(-1);
        }
        buf.writeBoolean(this.hasData());
        this.writeCapabilityData(buf, this.capabilityData);
    }

    public final boolean hasData() {
        return this.capabilityData != null;
    }

    @Nullable
    protected abstract DATA convertCapabilityToData(HANDLER var1);

    protected abstract DATA readCapabilityData(ByteBuf var1);

    protected abstract void writeCapabilityData(ByteBuf var1, DATA var2);

    public static abstract class Handler<HANDLER, DATA, MESSAGE extends MessageUpdateContainerCapability<HANDLER, DATA>>
    implements IMessageHandler<MESSAGE, IMessage> {
        @Nullable
        public final IMessage onMessage(MESSAGE message, MessageContext ctx) {
            if (!((MessageUpdateContainerCapability)message).hasData()) {
                return null;
            }
            ModJamPacks.proxy.getThreadListener(ctx).func_152344_a(() -> {
                Container container;
                EntityPlayer player = ModJamPacks.proxy.getPlayer(ctx);
                if (message.windowID == 0) {
                    container = player.field_71069_bz;
                } else if (message.windowID == player.field_71070_bA.field_75152_c) {
                    container = player.field_71070_bA;
                } else {
                    return;
                }
                ItemStack originalStack = container.func_75139_a(message.slotNumber).func_75211_c();
                Object originalHandler = originalStack.getCapability(message.capability, message.facing);
                if (originalHandler != null) {
                    ItemStack newStack = originalStack.func_77946_l();
                    Object newHandler = newStack.getCapability(message.capability, message.facing);
                    assert (newHandler != null);
                    this.applyCapabilityData(newHandler, message.capabilityData);
                    if (!originalHandler.equals(newHandler)) {
                        container.func_75141_a(message.slotNumber, newStack);
                    }
                }
            });
            return null;
        }

        protected abstract void applyCapabilityData(HANDLER var1, DATA var2);
    }
}

