/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs.network;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import selim.modjam.packs.ModJamPacks;

public abstract class MessageBulkUpdateContainerCapability<HANDLER, DATA>
implements IMessage {
    final Capability<HANDLER> capability;
    @Nullable
    EnumFacing facing;
    int windowID;
    final TIntObjectMap<DATA> capabilityData = new TIntObjectHashMap();

    protected MessageBulkUpdateContainerCapability(Capability<HANDLER> capability) {
        this.capability = capability;
    }

    public MessageBulkUpdateContainerCapability(Capability<HANDLER> capability, @Nullable EnumFacing facing, int windowID, NonNullList<ItemStack> items) {
        this.capability = capability;
        this.facing = facing;
        this.windowID = windowID;
        for (int index = 0; index < items.size(); ++index) {
            DATA data;
            ItemStack stack = (ItemStack)items.get(index);
            Object handler = stack.getCapability(capability, facing);
            if (handler == null || (data = this.convertCapabilityToData(handler)) == null) continue;
            this.capabilityData.put(index, data);
        }
    }

    public final void fromBytes(ByteBuf buf) {
        this.windowID = buf.readInt();
        byte facingIndex = buf.readByte();
        this.facing = facingIndex >= 0 ? EnumFacing.func_82600_a((int)facingIndex) : null;
        int numEntries = buf.readInt();
        for (int i = 0; i < numEntries; ++i) {
            int index = buf.readInt();
            DATA data = this.readCapabilityData(buf);
            this.capabilityData.put(index, data);
        }
    }

    public final void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowID);
        if (this.facing != null) {
            buf.writeByte(this.facing.func_176745_a());
        } else {
            buf.writeByte(-1);
        }
        buf.writeInt(this.capabilityData.size());
        this.capabilityData.forEachEntry((index, data) -> {
            buf.writeInt(index);
            this.writeCapabilityData(buf, data);
            return true;
        });
    }

    public final boolean hasData() {
        return !this.capabilityData.isEmpty();
    }

    @Nullable
    protected abstract DATA convertCapabilityToData(HANDLER var1);

    protected abstract DATA readCapabilityData(ByteBuf var1);

    protected abstract void writeCapabilityData(ByteBuf var1, DATA var2);

    public static abstract class Handler<HANDLER, DATA, MESSAGE extends MessageBulkUpdateContainerCapability<HANDLER, DATA>>
    implements IMessageHandler<MESSAGE, IMessage> {
        @Nullable
        public final IMessage onMessage(MESSAGE message, MessageContext ctx) {
            if (!((MessageBulkUpdateContainerCapability)message).hasData()) {
                return null;
            }
            ModJamPacks.proxy.getThreadListener(ctx).func_152344_a(() -> {
                Container container;
                EntityPlayer player = ModJamPacks.proxy.getPlayer(ctx);
                if (message.windowID == 0) {
                    container = player.field_71069_bz;
                } else if (message.windowID == player.field_71070_bA.field_75152_c) {
                    container = player.field_71070_bA;
                } else {
                    return;
                }
                message.capabilityData.forEachEntry((index, data) -> {
                    ItemStack originalStack = container.func_75139_a(index).func_75211_c();
                    Object originalHandler = originalStack.getCapability(message.capability, message.facing);
                    if (originalHandler != null) {
                        ItemStack newStack = originalStack.func_77946_l();
                        Object newHandler = newStack.getCapability(message.capability, message.facing);
                        assert (newHandler != null);
                        this.applyCapabilityData(newHandler, data);
                        if (!originalHandler.equals(newHandler)) {
                            container.func_75141_a(index, newStack);
                        }
                    }
                    return true;
                });
            });
            return null;
        }

        protected abstract void applyCapabilityData(HANDLER var1, DATA var2);
    }
}

