/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import selim.modjam.packs.network.CapabilityContainerListener;

@Mod.EventBusSubscriber
public class CapabilityContainerListenerManager {
    private static final Set<Function<EntityPlayerMP, CapabilityContainerListener>> containerListenerFactories = new HashSet<Function<EntityPlayerMP, CapabilityContainerListener>>();

    public static void registerListenerFactory(Function<EntityPlayerMP, CapabilityContainerListener> factory) {
        containerListenerFactories.add(factory);
    }

    public static class EventHandler {
        private static void addListeners(EntityPlayerMP player, Container container) {
            containerListenerFactories.forEach(factory -> container.func_75132_a((IContainerListener)factory.apply(player)));
        }

        @SubscribeEvent
        public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.player;
                EventHandler.addListeners(player, player.field_71069_bz);
            }
        }

        @SubscribeEvent
        public static void playerClone(PlayerEvent.Clone event) {
            if (event.getEntityPlayer() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
                EventHandler.addListeners(player, player.field_71069_bz);
            }
        }

        @SubscribeEvent
        public static void containerOpen(PlayerContainerEvent.Open event) {
            if (event.getEntityPlayer() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
                EventHandler.addListeners(player, event.getContainer());
            }
        }
    }
}

