/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs.items;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import selim.modjam.packs.ModJamPacks;
import selim.modjam.packs.capabilities.CapabilityBackpackHandler;
import selim.modjam.packs.capabilities.IBackpackHandler;
import selim.modjam.packs.items.IBackpackUpgrade;

public class ItemCollectionUpgrade
extends Item
implements IBackpackUpgrade {
    public ItemCollectionUpgrade() {
        this.setRegistryName(new ResourceLocation("selimpacks", "collection_upgrade"));
        this.func_77655_b("selimpacks:collection_upgrade");
        this.func_77625_d(1);
        this.func_77637_a(ModJamPacks.CREATIVE_TAB);
    }

    @SubscribeEvent
    public static void onPickup(EntityItemPickupEvent event) {
        ItemStack consumedStack = event.getItem().func_92059_d().func_77946_l();
        ItemStack pickupStack = consumedStack.func_77946_l();
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (stack.func_190926_b() || !stack.hasCapability(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY, null)) {
            return;
        }
        IBackpackHandler backpack = (IBackpackHandler)stack.getCapability(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY, null);
        for (int s = 0; s < backpack.getUpgradeSlots(); ++s) {
            if (!(backpack.getUpgradeStackInSlot(s).func_77973_b() instanceof ItemCollectionUpgrade)) continue;
            for (int i = 0; !consumedStack.func_190926_b() && i < backpack.getSlots(); ++i) {
                consumedStack = backpack.insertItem(i, consumedStack, false);
            }
            if (!consumedStack.func_190926_b()) {
                if (ItemCollectionUpgrade.areStacksSimilar(pickupStack, consumedStack, 0)) {
                    return;
                }
                event.setResult(Event.Result.ALLOW);
                event.getItem().func_92058_a(consumedStack);
                continue;
            }
            event.setResult(Event.Result.ALLOW);
            event.getItem().func_70106_y();
        }
    }

    private static boolean areStacksSimilar(ItemStack a, ItemStack b, int flags) {
        return !(!a.func_77973_b().equals(b.func_77973_b()) || (flags & 1) <= 0 && a.func_77960_j() != b.func_77960_j() || (flags & 2) <= 0 && a.func_190916_E() != b.func_190916_E() || (flags & 4) <= 0 && (a.func_77942_o() != b.func_77942_o() || !a.func_77942_o() || !a.func_77978_p().equals((Object)b.func_77978_p())));
    }
}

