/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs.capabilities;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import selim.modjam.packs.ModConfig;
import selim.modjam.packs.capabilities.CapabilityBackpackHandler;
import selim.modjam.packs.capabilities.IBackpackHandler;
import selim.modjam.packs.items.ItemCapacityUpgrade;

public class BackpackHandler
extends ItemStackHandler
implements IBackpackHandler,
ICapabilitySerializable<NBTTagCompound> {
    private ItemStack backpack;
    private final ItemStackHandler contents;
    private final ItemStackHandler upgrades = new ItemStackHandler(9);
    private final List<ItemStackHandler> sizeUpgrades = new LinkedList<ItemStackHandler>();
    private CombinedInvWrapper wrapper;

    protected BackpackHandler() {
        this(ModConfig.DEFAULT_SIZE);
    }

    public BackpackHandler(ItemStack chestplate) {
        this(ModConfig.getSize(chestplate));
        this.backpack = chestplate;
    }

    private BackpackHandler(int size) {
        this.contents = new ItemStackHandler(size);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        boolean hasCap = false;
        if (this.backpack == null) {
            hasCap = true;
        } else {
            NBTTagCompound nbt = this.backpack.func_77978_p();
            if (nbt != null) {
                hasCap = nbt.func_74767_n("selimpacks:backpack");
            }
        }
        if (hasCap) {
            return capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) || capability.equals(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY);
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.hasCapability(capability, facing)) {
            return null;
        }
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.contents);
        }
        if (capability.equals(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY)) {
            return (T)CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound upperNbt = super.serializeNBT();
        upperNbt.func_74782_a("upgrades", (NBTBase)this.upgrades.serializeNBT());
        return upperNbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound upgrades = nbt.func_74775_l("upgrades");
        this.upgrades.deserializeNBT(upgrades);
        super.deserializeNBT(nbt);
    }

    public void setSize(int size) {
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.wrapper == null) {
            this.updateSizeUpgrades();
        }
        this.wrapper.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        if (this.wrapper == null) {
            this.updateSizeUpgrades();
        }
        return this.wrapper.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.wrapper == null) {
            this.updateSizeUpgrades();
        }
        return this.wrapper.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.wrapper == null) {
            this.updateSizeUpgrades();
        }
        return this.wrapper.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.wrapper == null) {
            this.updateSizeUpgrades();
        }
        return this.wrapper.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        if (this.wrapper == null) {
            this.updateSizeUpgrades();
        }
        return this.wrapper.getSlotLimit(slot);
    }

    public int getInternalSlots() {
        return this.contents.getSlots();
    }

    public ItemStack getInternalStackInSlot(int slot) {
        return this.contents.getStackInSlot(slot);
    }

    public ItemStack extractInternalItem(int slot, int amount, boolean simulate) {
        return this.contents.extractItem(slot, amount, simulate);
    }

    public int getInternalSlotLimit(int slot) {
        return this.contents.getSlotLimit(slot);
    }

    @Override
    public void setUpgradeStackInSlot(int slot, ItemStack stack) {
        this.upgrades.setStackInSlot(slot, stack);
        this.updateSizeUpgrades();
    }

    @Override
    public int getUpgradeSlots() {
        return this.upgrades.getSlots();
    }

    @Override
    public ItemStack getUpgradeStackInSlot(int slot) {
        return this.upgrades.getStackInSlot(slot);
    }

    @Override
    public ItemStack insertUpgradeItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack toReturn = this.upgrades.insertItem(slot, stack, simulate);
        this.updateSizeUpgrades();
        return toReturn;
    }

    @Override
    public ItemStack extractUpgradeItem(int slot, int amount, boolean simulate) {
        ItemStack toReturn = this.upgrades.extractItem(slot, amount, simulate);
        this.updateSizeUpgrades();
        return toReturn;
    }

    @Override
    public int getUpgradeSlotLimit(int slot) {
        return this.upgrades.getSlotLimit(slot);
    }

    private void updateSizeUpgrades() {
        this.sizeUpgrades.clear();
        for (int s = 0; s < this.upgrades.getSlots(); ++s) {
            IItemHandler handler;
            ItemStack stack = this.upgrades.getStackInSlot(s);
            if (!(stack.func_77973_b() instanceof ItemCapacityUpgrade) || !((handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof ItemStackHandler)) continue;
            this.sizeUpgrades.add((ItemStackHandler)handler);
        }
        ItemStackHandler[] handlers = new ItemStackHandler[this.sizeUpgrades.size() + 1];
        handlers[0] = this.contents;
        for (int i = 0; i < this.sizeUpgrades.size(); ++i) {
            handlers[i + 1] = this.sizeUpgrades.get(i);
        }
        System.out.println("constructing new wrapper with " + handlers.length + " handlers");
        this.wrapper = new CombinedInvWrapper((IItemHandlerModifiable[])handlers);
    }
}

