/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs;

import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTUtils {
    public static String getKeyType(NBTTagCompound nbt, String key) {
        for (int i = 0; i < NBTBase.field_82578_b.length; ++i) {
            if (!nbt.func_150297_b(key, i)) continue;
            return NBTBase.field_82578_b[i];
        }
        return null;
    }

    public static String getNBTBaseType(NBTBase base) {
        for (int i = 0; i < NBTBase.field_82578_b.length; ++i) {
            if (base.func_74732_a() != i) continue;
            return NBTBase.field_82578_b[i];
        }
        return null;
    }

    public static void nbtToStringList(List<String> output, NBTTagCompound nbt) {
        NBTUtils.nbtToStringList(output, nbt, "", null);
    }

    public static void nbtToStringList(List<String> output, NBTTagCompound nbt, String name) {
        NBTUtils.nbtToStringList(output, nbt, "", name);
    }

    private static void addNBTKey(List<String> output, NBTTagCompound nbt, String indent, String key) {
        if (nbt == null) {
            return;
        }
        block14 : switch (NBTUtils.getKeyType(nbt, key)) {
            case "END": {
                break;
            }
            case "BYTE": {
                output.add(" " + indent + key + ": " + nbt.func_74771_c(key) + "b,");
                break;
            }
            case "SHORT": {
                output.add(" " + indent + key + ": " + nbt.func_74765_d(key) + "s,");
                break;
            }
            case "INT": {
                output.add(" " + indent + key + ": " + nbt.func_74762_e(key) + ",");
                break;
            }
            case "LONG": {
                output.add(" " + indent + key + ": " + nbt.func_74763_f(key) + "L,");
                break;
            }
            case "FLOAT": {
                output.add(" " + indent + key + ": " + nbt.func_74760_g(key) + ",");
                break;
            }
            case "DOUBLE": {
                output.add(" " + indent + key + ": " + nbt.func_74769_h(key) + ",");
                break;
            }
            case "BYTE[]": {
                byte[] bytes;
                output.add(" " + indent + key + ": [");
                for (byte b : bytes = nbt.func_74770_j(key)) {
                    output.add("  " + indent + b + ",");
                }
                output.add(" " + indent + "],");
                break;
            }
            case "STRING": {
                output.add(" " + indent + key + ": \"" + nbt.func_74779_i(key) + "\",");
                break;
            }
            case "LIST": {
                for (int i = 0; i < NBTBase.field_82578_b.length; ++i) {
                    NBTTagList tagList = nbt.func_150295_c(key, i);
                    if (tagList == null || tagList.func_82582_d()) continue;
                    output.add(" " + indent + key + ": [");
                    for (int ti = 0; ti < tagList.func_74745_c(); ++ti) {
                        NBTUtils.addNBTBase(output, tagList.func_179238_g(ti), "  " + indent, String.valueOf(ti));
                    }
                    output.add(" " + indent + "],");
                    break block14;
                }
                break;
            }
            case "COMPOUND": {
                NBTUtils.nbtToStringList(output, nbt.func_74775_l(key), " " + indent, key);
                break;
            }
            case "INT[]": {
                int[] ints;
                output.add(" " + indent + key + ": [");
                for (int i : ints = nbt.func_74759_k(key)) {
                    output.add("  \"" + indent + i + "\",");
                }
                output.add(" " + indent + "],");
            }
        }
    }

    private static void addNBTBase(List<String> output, NBTBase base, String indent, String name) {
        switch (NBTUtils.getNBTBaseType(base)) {
            case "END": {
                break;
            }
            case "BYTE": {
                output.add(" " + indent + name + ": " + ((NBTTagByte)base).func_150290_f() + "b,");
                break;
            }
            case "SHORT": {
                output.add(" " + indent + name + ": " + ((NBTTagShort)base).func_150289_e() + "s,");
                break;
            }
            case "INT": {
                output.add(" " + indent + name + ": " + ((NBTTagInt)base).func_150287_d() + ",");
                break;
            }
            case "LONG": {
                output.add(" " + indent + name + ": " + ((NBTTagLong)base).func_150291_c() + "L,");
                break;
            }
            case "FLOAT": {
                output.add(" " + indent + name + ": " + ((NBTTagFloat)base).func_150288_h() + ",");
                break;
            }
            case "DOUBLE": {
                output.add(" " + indent + name + ": " + ((NBTTagDouble)base).func_150286_g() + ",");
                break;
            }
            case "BYTE[]": {
                byte[] bytes;
                output.add(" " + indent + name + ": [");
                for (byte b : bytes = ((NBTTagByteArray)base).func_150292_c()) {
                    output.add("  " + indent + b + ",");
                }
                output.add(" " + indent + "],");
                break;
            }
            case "STRING": {
                output.add(" " + indent + name + ": \"" + ((NBTTagString)base).func_150285_a_() + "\",");
                break;
            }
            case "LIST": {
                NBTTagList tagList = (NBTTagList)base;
                if (tagList == null) break;
                output.add(" " + indent + name + ": [");
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTUtils.addNBTBase(output, tagList.func_179238_g(i), "  " + indent, String.valueOf(i));
                }
                output.add(" " + indent + "],");
                break;
            }
            case "COMPOUND": {
                NBTUtils.nbtToStringList(output, (NBTTagCompound)base, " " + indent, name);
                break;
            }
            case "INT[]": {
                int[] ints;
                output.add(" " + indent + name + ": [");
                for (int i : ints = ((NBTTagIntArray)base).func_150302_c()) {
                    output.add("  " + indent + i);
                }
                output.add(" " + indent + "],");
            }
        }
    }

    public static void nbtToStringList(List<String> output, NBTTagCompound nbt, String indent, String name) {
        if (nbt == null) {
            return;
        }
        if (name != null && !name.equals("")) {
            output.add(indent + name + ": {");
        } else {
            output.add(indent + "{");
        }
        for (String key : nbt.func_150296_c()) {
            NBTUtils.addNBTKey(output, nbt, indent, key);
        }
        output.add(indent + "},");
    }
}

