/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs;

import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import selim.modjam.packs.BackpackTab;
import selim.modjam.packs.ModConfig;
import selim.modjam.packs.capabilities.BackpackHandler;
import selim.modjam.packs.capabilities.CapabilityBackpackHandler;
import selim.modjam.packs.capabilities.IBackpackHandler;
import selim.modjam.packs.items.ItemBackpack;
import selim.modjam.packs.network.MessageBulkUpdateContainerBackpack;
import selim.modjam.packs.network.MessageOpenBackpack;
import selim.modjam.packs.network.MessageOpenUpgrades;
import selim.modjam.packs.network.MessageUpdateContainerBackpack;
import selim.modjam.packs.proxy.CommonProxy;

@Mod(modid="selimpacks", name="Selim Backpacks", version="1.0", acceptedMinecraftVersions="[1.12.2]")
public class ModJamPacks {
    public static final String MODID = "selimpacks";
    public static final String NAME = "Selim Backpacks";
    public static final String VERSION = "1.0";
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("selimpacks", "backpack");
    public static final Logger LOGGER = LogManager.getLogger((String)"selimpacks");
    public static SimpleNetworkWrapper network;
    @SidedProxy(clientSide="selim.modjam.packs.proxy.ClientProxy", serverSide="selim.modjam.packs.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final BackpackTab CREATIVE_TAB;
    private static int packetId;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerEventListeners();
        CapabilityBackpackHandler.register();
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage(MessageBulkUpdateContainerBackpack.Handler.class, MessageBulkUpdateContainerBackpack.class, packetId++, Side.CLIENT);
        network.registerMessage(MessageUpdateContainerBackpack.Handler.class, MessageUpdateContainerBackpack.class, packetId++, Side.CLIENT);
        network.registerMessage(MessageOpenBackpack.Handler.class, MessageOpenBackpack.class, packetId++, Side.SERVER);
        network.registerMessage(MessageOpenUpgrades.Handler.class, MessageOpenUpgrades.class, packetId++, Side.SERVER);
        proxy.registerKeybinds();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NBTTagCompound innerNbt = new NBTTagCompound();
        innerNbt.func_74757_a("selimpacks:backpack", true);
        for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
            if (item instanceof ItemBackpack || !(item instanceof ItemArmor) || ((ItemArmor)item).field_77881_a != EntityEquipmentSlot.CHEST || ModConfig.getSize(item) == 0) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("id", item.getRegistryName().toString());
            nbt.func_74774_a("Count", (byte)1);
            nbt.func_74782_a("tag", (NBTBase)innerNbt);
            ItemStack stack = new ItemStack(nbt);
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(MODID, item.getRegistryName().func_110623_a() + "_backpack"), (ResourceLocation)new ResourceLocation(MODID, "backpack"), (ItemStack)stack, (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)item), CraftingHelper.getIngredient((Object)"chestWood")});
            BackpackTab.addBackpack(stack);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void stackCapAttach(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack == null || !(stack.func_77973_b() instanceof ItemArmor) || ((ItemArmor)stack.func_77973_b()).field_77881_a != EntityEquipmentSlot.CHEST) {
            return;
        }
        event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new BackpackHandler(stack));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.hasCapability(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY, null) || stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("selimpacks:backpack")) {
            IBackpackHandler backpack = (IBackpackHandler)stack.getCapability(CapabilityBackpackHandler.BACKPACK_HANDLER_CAPABILITY, null);
            event.getToolTip().add(I18n.func_135052_a((String)"misc.selimpacks:backpack_tooltip", (Object[])new Object[0]));
        }
    }

    static {
        CREATIVE_TAB = new BackpackTab();
        packetId = 1;
    }
}

