/*
 * Decompiled with CFR 0.152.
 */
package selim.modjam.packs;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="selimpacks")
@Config.LangKey(value="selimpacks:config.title")
public class ModConfig {
    @Config.Comment(value={"Default backpack size for any chestplate that doesn't have a defined size."})
    public static int DEFAULT_SIZE = 18;
    @Config.Comment(value={"Backpack sizes for all chestplates.", "Values must be a multiple of 9.", "Set the value to 0 to disable backpacks for the given chestplate."})
    public static final Map<String, Integer> PACK_SIZES = new HashMap<String, Integer>();

    public static int getSize(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return 0;
        }
        return ModConfig.getSize(stack.func_77973_b());
    }

    public static int getSize(Item item) {
        String id;
        if (DEFAULT_SIZE % 9 != 0) {
            DEFAULT_SIZE = 18;
        }
        if (!PACK_SIZES.containsKey(id = item.getRegistryName().toString())) {
            return DEFAULT_SIZE;
        }
        int size = PACK_SIZES.get(id);
        if (size % 9 != 0) {
            return DEFAULT_SIZE;
        }
        return size;
    }

    static {
        PACK_SIZES.put("minecraft:leather_chesplate", 27);
        PACK_SIZES.put("minecraft:chain_chesplate", 18);
        PACK_SIZES.put("minecraft:iron_chesplate", 9);
        PACK_SIZES.put("minecraft:gold_chesplate", 18);
        PACK_SIZES.put("minecraft:diamond_chesplate", 36);
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("selimpacks")) {
                ConfigManager.sync((String)"selimpacks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

