/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.yatm.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import party.lemons.yatm.YATM;
import party.lemons.yatm.capability.PlayerData;
import party.lemons.yatm.events.PlayerEvents;
import party.lemons.yatm.message.MessageSendPlayerInfo;
import party.lemons.yatm.playermobs.PlayerMob;
import party.lemons.yatm.playermobs.PlayerMobRegistry;
import party.lemons.yatm.playermobs.PlayerMobs;

public class MessageSetMobFromGui
implements IMessage {
    PlayerMob mob;

    public MessageSetMobFromGui() {
    }

    public MessageSetMobFromGui(PlayerMob mob) {
        this.mob = mob;
    }

    public void fromBytes(ByteBuf buf) {
        String s = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.mob = PlayerMobRegistry.fromString(s);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.mob.getRegistryName().toString());
    }

    public static class Handler
    implements IMessageHandler<MessageSetMobFromGui, IMessage> {
        public IMessage onMessage(MessageSetMobFromGui message, MessageContext ctx) {
            EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
            serverPlayer.func_71121_q().func_152344_a(() -> {
                PlayerData data = (PlayerData)serverPlayer.getCapability(PlayerData.CAPABILITY, null);
                data.setMob(message.mob);
                data.setSelected(true);
                try {
                    if (message.mob != PlayerMobs.PLAYER) {
                        EntityLivingBase livingBase = (EntityLivingBase)message.mob.getMobClass().getConstructor(World.class).newInstance(serverPlayer.func_71121_q());
                        PlayerEvents.setPlayerSize((EntityPlayer)serverPlayer, livingBase.field_70130_N, livingBase.field_70131_O, livingBase.func_70047_e());
                        serverPlayer.func_174826_a(livingBase.func_174813_aQ().func_186670_a(serverPlayer.func_180425_c()));
                    } else {
                        PlayerEvents.setPlayerSize((EntityPlayer)serverPlayer, 0.6f, 1.8f, serverPlayer.getDefaultEyeHeight());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                message.mob.onInitialSpawn((EntityPlayer)serverPlayer);
                YATM.NETWORK.sendToAll((IMessage)new MessageSendPlayerInfo(serverPlayer.func_110124_au(), message.mob.getRegistryName().toString()));
            });
            return null;
        }
    }
}

