/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.yatm.gen;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.IWorldGenerator;
import party.lemons.yatm.entity.EntityHumanInventory;

public class GenPlayerHouse
implements IWorldGenerator {
    private static final ResourceLocation[] LOCATIONS = new ResourceLocation[]{new ResourceLocation("yatm", "player_house_1"), new ResourceLocation("yatm", "player_house_2")};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_180494_b(new BlockPos(8 + chunkX * 16, 100, 8 + chunkZ * 16)) == Biomes.field_76778_j || random.nextInt(75) != 0) {
            return;
        }
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos(8 + (chunkX * 16 + random.nextInt(16)), 100, 8 + (chunkZ * 16 + random.nextInt(16)));
        basePos.func_185336_p(world.func_175672_r((BlockPos)basePos).func_177956_o() - 1);
        if (world.func_180495_p((BlockPos)basePos).func_177230_c() instanceof BlockLiquid || world.func_180495_p(basePos.func_177984_a()).func_177230_c() instanceof BlockLiquid) {
            return;
        }
        while (world.func_180495_p((BlockPos)basePos).func_177230_c() instanceof BlockLeaves || world.func_180495_p((BlockPos)basePos).func_177230_c() instanceof BlockLog) {
            basePos.func_185336_p(basePos.func_177956_o() - 1);
        }
        PlacementSettings settings = new PlacementSettings();
        Template template = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), LOCATIONS[random.nextInt(LOCATIONS.length)]);
        settings.func_186220_a(Rotation.values()[random.nextInt(Rotation.values().length)]);
        for (int i = 0; i < 10; ++i) {
            if (!world.func_175623_d(basePos.func_177967_a(EnumFacing.DOWN, i).func_177967_a(EnumFacing.EAST, 5).func_177967_a(EnumFacing.SOUTH, 5))) continue;
            return;
        }
        template.func_186253_b(world, (BlockPos)basePos, settings);
        Map dataBlocks = template.func_186258_a((BlockPos)basePos, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            String[] data = ((String)entry.getValue()).split(" ");
            if (data.length == 0) {
                return;
            }
            BlockPos pos = (BlockPos)entry.getKey();
            if (data[0].equalsIgnoreCase("furnace")) {
                TileEntity furnace = world.func_175625_s(pos.func_177977_b());
                if (furnace != null) {
                    ((TileEntityFurnace)furnace).func_70299_a(2, new ItemStack(Items.field_151042_j, 1 + random.nextInt(10)));
                }
            } else if (data[0].equalsIgnoreCase("entity_player")) {
                EntityHumanInventory human = new EntityHumanInventory(world);
                human.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                world.func_72838_d((Entity)human);
            } else if (data[0].equalsIgnoreCase("chest_player")) {
                world.func_175698_g(pos.func_177977_b());
                world.func_175656_a(pos.func_177977_b(), Blocks.field_150486_ae.func_176223_P());
                TileEntity chest = world.func_175625_s(pos.func_177977_b());
                if (chest != null && chest instanceof TileEntityLockableLoot) {
                    String[] loot = new String[]{"spawn_bonus_chest", "woodland_mansion", "stronghold_corridor"};
                    this.fillWithLoot(pos.func_177977_b(), (TileEntityLockableLoot)chest, new ResourceLocation(loot[random.nextInt(loot.length)]));
                }
            }
            world.func_175698_g(pos);
        }
    }

    public void fillWithLoot(BlockPos pos, TileEntityLockableLoot te, ResourceLocation loot) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        LootTable loottable = te.func_145831_w().func_184146_ak().func_186521_a(loot);
        Random random = new Random();
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)te.func_145831_w());
        loottable.func_186460_a((IInventory)te, random, lootcontext$builder.func_186471_a());
    }
}

