/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.yatm.events;

import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import party.lemons.yatm.YATM;
import party.lemons.yatm.capability.PlayerData;
import party.lemons.yatm.entity.EntityHuman;
import party.lemons.yatm.message.MessageForceGui;
import party.lemons.yatm.playermobs.PlayerMob;

@Mod.EventBusSubscriber
public class PlayerEvents {
    public static final Method setSizeMethod = PlayerEvents.getSetSizeMethod();
    public static HashMap<EntityPlayer, EntityLivingBase> cache = new HashMap();

    @SubscribeEvent
    public static void onTarget(LivingSetAttackTargetEvent event) {
        PlayerMob mob;
        EntityPlayer player;
        if (event.getTarget() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getTarget();
            mob = ((PlayerData)player.getCapability(PlayerData.CAPABILITY, null)).getMob();
            if (event.getEntityLiving() instanceof IMob && !mob.shouldMobsAttack()) {
                event.getEntityLiving().func_70604_c(null);
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
        if (event.getEntityLiving() instanceof EntityHuman) {
            if (event.getTarget() instanceof EntityCreeper) {
                event.getEntityLiving().func_70604_c(null);
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
            if (event.getTarget() instanceof EntityPlayer && !(mob = ((PlayerData)(player = (EntityPlayer)event.getTarget()).getCapability(PlayerData.CAPABILITY, null)).getMob()).shouldPlayersAttack()) {
                event.getEntityLiving().func_70604_c(null);
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent event) {
        if (event.getSource().func_76364_f() instanceof EntityPlayer) {
            event.setAmount(event.getAmount() * (float)((PlayerData)event.getSource().func_76364_f().getCapability(PlayerData.CAPABILITY, null)).getMob().getMeleeAttackFactor());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            ((PlayerData)event.getSource().func_76346_g().getCapability(PlayerData.CAPABILITY, null)).getMob().onKill((EntityPlayer)event.getSource().func_76346_g(), event.getEntityLiving());
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            ((PlayerData)event.getEntityLiving().getCapability(PlayerData.CAPABILITY, null)).setSelected(false);
        }
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.func_70089_S() && !((PlayerData)player.getCapability(PlayerData.CAPABILITY, null)).hasSelected() && !player.field_70170_p.field_72995_K) {
            YATM.NETWORK.sendTo((IMessage)new MessageForceGui(), (EntityPlayerMP)player);
        }
        if (!cache.containsKey(player) || cache.get(player) == null || ((PlayerData)player.getCapability(PlayerData.CAPABILITY, null)).getMob().getMobClass() != cache.get(player).getClass()) {
            PlayerEvents.cachePlayer(player);
        }
        ((PlayerData)player.getCapability(PlayerData.CAPABILITY, null)).getMob().onPlayerTick(player);
    }

    public static void setPlayerSize(EntityPlayer player, float width, float height, float eye) {
        try {
            setSizeMethod.invoke((Object)player, Float.valueOf(width), Float.valueOf(height));
            player.eyeHeight = eye;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Method getSetSizeMethod() {
        Method met = ReflectionHelper.findMethod(Entity.class, (String)"setSize", (String)"func_70105_a", (Class[])new Class[]{Float.TYPE, Float.TYPE});
        met.setAccessible(true);
        return met;
    }

    public static void cachePlayer(EntityPlayer player) {
        try {
            Class livingClass = ((PlayerData)player.getCapability(PlayerData.CAPABILITY, null)).getMob().getMobClass();
            EntityLivingBase inst = (EntityLivingBase)livingClass.getConstructor(World.class).newInstance(player.field_70170_p);
            cache.put(player, inst);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

