/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.yatm.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import party.lemons.yatm.playermobs.PlayerMob;
import party.lemons.yatm.playermobs.PlayerMobRegistry;
import party.lemons.yatm.playermobs.PlayerMobs;

public interface PlayerData {
    @CapabilityInject(value=PlayerData.class)
    public static final Capability<PlayerData> CAPABILITY = null;

    public PlayerMob getMob();

    public void setMob(PlayerMob var1);

    public boolean hasSelected();

    public void setSelected(boolean var1);

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private PlayerData instance = (PlayerData)CAPABILITY.getDefaultInstance();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, (Object)this.instance, null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<PlayerData> {
        @Nullable
        public NBTBase writeNBT(Capability<PlayerData> capability, PlayerData instance, EnumFacing side) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("mob", instance.getMob().getRegistryName().toString());
            tags.func_74757_a("selected", instance.hasSelected());
            return tags;
        }

        public void readNBT(Capability<PlayerData> capability, PlayerData instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tags = (NBTTagCompound)nbt;
            String mob = tags.func_74779_i("mob");
            instance.setMob(PlayerMobRegistry.fromString(mob));
            instance.setSelected(tags.func_74767_n("selected"));
        }
    }

    public static class Impl
    implements PlayerData {
        private PlayerMob mob = PlayerMobs.PLAYER;
        private boolean hasSelected = false;

        @Override
        public PlayerMob getMob() {
            return this.mob;
        }

        @Override
        public void setMob(PlayerMob mob) {
            this.mob = mob;
        }

        @Override
        public boolean hasSelected() {
            return this.hasSelected;
        }

        @Override
        public void setSelected(boolean selected) {
            this.hasSelected = selected;
        }
    }
}

