/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.trebuchet.tile;

import com.cout970.trebuchet.BlockHolder;
import com.cout970.trebuchet.EnumSound;
import com.cout970.trebuchet.block.BlockTrebuchet;
import com.cout970.trebuchet.render.TrebuchetAnimation;
import com.cout970.trebuchet.render.Util;
import com.cout970.trebuchet.render.UtilKt;
import com.cout970.trebuchet.tile.StackList;
import com.cout970.trebuchet.tile.TileBase;
import com.cout970.trebuchet.tile.TileGap;
import com.cout970.trebuchet.tile.TileTrebuchet;
import com.cout970.vector.extensions.VectorConstructorsKt;
import com.cout970.vector.extensions.VectorOperationsKt;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0001=B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u0004\u0018\u00010\u001eJ\b\u0010%\u001a\u00020\u0019H\u0002J\u0006\u0010&\u001a\u00020!J\b\u0010'\u001a\u00020!H\u0002J\b\u0010(\u001a\u00020!H\u0002J\u0006\u0010)\u001a\u00020\u000eJ\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u00020#J\u000e\u00101\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u00102\u001a\u00020!J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020!2\u0006\u00107\u001a\u000205H\u0016J\u0006\u00108\u001a\u00020!J\u0010\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0012H\u0016J\b\u0010;\u001a\u00020!H\u0016J\u0010\u0010<\u001a\u0002052\u0006\u00104\u001a\u000205H\u0016R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/cout970/trebuchet/tile/TileTrebuchet;", "Lcom/cout970/trebuchet/tile/TileBase;", "Lnet/minecraft/util/ITickable;", "()V", "active", "", "getActive", "()Z", "animation", "Lcom/cout970/trebuchet/render/TrebuchetAnimation;", "getAnimation", "()Lcom/cout970/trebuchet/render/TrebuchetAnimation;", "breaking", "constructionItems", "Lcom/cout970/trebuchet/tile/StackList;", "getConstructionItems", "()Lcom/cout970/trebuchet/tile/StackList;", "cooldown", "", "facing", "Lnet/minecraft/util/EnumFacing;", "getFacing", "()Lnet/minecraft/util/EnumFacing;", "firing", "projectile", "Lnet/minecraft/entity/Entity;", "projectileUUID", "Ljava/util/UUID;", "ready", "applyFacing", "Lnet/minecraft/util/math/BlockPos;", "pos", "build", "", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "checkBlocks", "createProjectile", "disable", "doWork", "fireProjectile", "getConstructionMaterials", "getMaxRenderDistanceSquared", "", "getRenderBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "onClick", "state", "Lnet/minecraft/block/state/IBlockState;", "onStructureBreak", "placeBlocks", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "receiveFromServer", "data", "setProjectilePosition", "shouldRenderInPass", "pass", "update", "writeToNBT", "Companion", "trebuchet"})
public final class TileTrebuchet
extends TileBase
implements ITickable {
    private boolean ready = true;
    private boolean firing;
    private int cooldown;
    private Entity projectile;
    private UUID projectileUUID;
    @NotNull
    private final TrebuchetAnimation animation = new TrebuchetAnimation();
    @NotNull
    private final StackList constructionItems = this.getConstructionMaterials();
    private volatile boolean breaking;
    @NotNull
    private static final List<List<boolean[]>> scheme;
    private static final float PIXEL = 0.0625f;
    private static final List<AxisAlignedBB> hitboxes;
    public static final Companion Companion;

    @NotNull
    public final TrebuchetAnimation getAnimation() {
        return this.animation;
    }

    @NotNull
    public final StackList getConstructionItems() {
        return this.constructionItems;
    }

    @NotNull
    public final EnumFacing getFacing() {
        IBlockState state;
        IBlockState iBlockState = state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        if (iBlockState.func_177227_a().contains(BlockTrebuchet.Companion.getPROPERTY_FACING())) {
            Comparable comparable = state.func_177229_b((IProperty)BlockTrebuchet.Companion.getPROPERTY_FACING());
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.getValue(BlockTrebuchet.PROPERTY_FACING)");
            return (EnumFacing)comparable;
        }
        return EnumFacing.NORTH;
    }

    public final boolean getActive() {
        IBlockState state;
        IBlockState iBlockState = state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        if (iBlockState.func_177227_a().contains(BlockTrebuchet.Companion.getPROPERTY_ACTIVE())) {
            Comparable comparable = state.func_177229_b((IProperty)BlockTrebuchet.Companion.getPROPERTY_ACTIVE());
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.getValue(BlockTrebuchet.PROPERTY_ACTIVE)");
            return (Boolean)comparable;
        }
        return false;
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB axisAlignedBB = TileEntity.INFINITE_EXTENT_AABB;
        Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB, (String)"INFINITE_EXTENT_AABB");
        return axisAlignedBB;
    }

    @Override
    public void receiveFromServer(@NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int event = data.func_74762_e("event");
        switch (event) {
            case 1: {
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                this.animation.startAnimation(world, true);
                BlockPos blockPos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                double d = blockPos.func_177958_n();
                BlockPos blockPos2 = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
                double d2 = blockPos2.func_177956_o();
                BlockPos blockPos3 = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos");
                this.field_145850_b.func_184134_a(d, d2, (double)blockPos3.func_177952_p(), EnumSound.FIRE.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                this.projectileUUID = UUID.fromString(data.func_74779_i("projectile"));
                this.cooldown = 30;
                break;
            }
            case 2: {
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                this.animation.startAnimation(world, false);
                BlockPos blockPos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                double d = blockPos.func_177958_n();
                BlockPos blockPos4 = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"pos");
                double d3 = blockPos4.func_177956_o();
                BlockPos blockPos5 = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"pos");
                this.field_145850_b.func_184134_a(d, d3, (double)blockPos5.func_177952_p(), EnumSound.RELOAD.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            default: {
                this.projectile = null;
                this.projectileUUID = null;
                this.firing = false;
            }
        }
    }

    public void func_73660_a() {
        NBTTagCompound nBTTagCompound;
        TileTrebuchet tileTrebuchet;
        if (this.field_145850_b.field_72995_K && this.projectile == null && this.projectileUUID != null) {
            NBTTagCompound nBTTagCompound2;
            block5: {
                List list = this.field_145850_b.func_72910_y();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"world.getLoadedEntityList()");
                Iterable iterable = list;
                tileTrebuchet = this;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    Entity it;
                    Entity entity2 = it = (Entity)t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"it");
                    if (!Intrinsics.areEqual((Object)entity2.func_110124_au(), (Object)this.projectileUUID)) continue;
                    nBTTagCompound2 = (NBTTagCompound)t;
                    break block5;
                }
                nBTTagCompound2 = null;
            }
            nBTTagCompound = nBTTagCompound2;
            tileTrebuchet.projectile = (Entity)nBTTagCompound;
            this.setProjectilePosition();
        }
        if (this.cooldown > 0) {
            int n = this.cooldown;
            this.cooldown = n + -1;
            Entity entity3 = this.projectile;
            if (entity3 != null) {
                Entity entity4;
                Entity it = entity4 = entity3;
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                this.animation.update(world, 0.0f);
                this.setProjectilePosition();
            }
            if (!this.ready && this.cooldown == 0) {
                this.fireProjectile();
                this.projectile = null;
                this.projectileUUID = null;
                this.firing = false;
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                tileTrebuchet = this;
                NBTTagCompound $receiver = nBTTagCompound3;
                $receiver.func_74768_a("event", 3);
                nBTTagCompound = nBTTagCompound3;
                tileTrebuchet.sendToClient(nBTTagCompound);
            }
        }
    }

    public final void setProjectilePosition() {
        block1: {
            Entity entity2;
            Entity entity3 = this.projectile;
            if (entity3 == null) break block1;
            Entity it = entity2 = entity3;
            Vec3d end = Util.INSTANCE.collideBottom(this.animation.getWireKinematic().getEnd(), 0.5);
            BlockPos blockPos = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
            Number number = blockPos.func_177958_n();
            BlockPos blockPos2 = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
            Number number2 = blockPos2.func_177956_o();
            BlockPos blockPos3 = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos");
            Vec3d vec3d = VectorConstructorsKt.vec3Of((Number)number, (Number)number2, (Number)blockPos3.func_177952_p());
            EnumFacing enumFacing = this.getFacing().func_176734_d();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing.opposite");
            Vec3d pos = VectorOperationsKt.plus((Vec3d)VectorOperationsKt.plus((Vec3d)vec3d, (Vec3d)UtilKt.rotatePoint(enumFacing, VectorConstructorsKt.vec3Of((Number)0.5), end)), (Vec3d)VectorConstructorsKt.vec3Of((Number)this.getFacing().func_82601_c(), (Number)0, (Number)this.getFacing().func_82599_e()));
            Entity entity4 = this.projectile;
            if (entity4 != null) {
                entity4.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
        }
    }

    private final void fireProjectile() {
        block0: {
            Entity entity2;
            Entity entity3 = this.projectile;
            if (entity3 == null) break block0;
            Entity tnt = entity2 = entity3;
            tnt.field_70159_w = (double)this.getFacing().func_82601_c() * -6.0;
            tnt.field_70179_y = (double)this.getFacing().func_82599_e() * -6.0;
            tnt.func_189654_d(false);
        }
    }

    private final Entity createProjectile() {
        Vec3d start = VectorConstructorsKt.vec3Of((Number)-0.25, (Number)0.25, (Number)-7.5);
        AxisAlignedBB box = UtilKt.rotateBox(this.getFacing(), VectorConstructorsKt.vec3Of((Number)0.5), UtilKt.toAABBWith(start, VectorOperationsKt.plus((Vec3d)start, (Vec3d)VectorConstructorsKt.vec3Of((Number)1.5))));
        List list = this.field_145850_b.func_175674_a(null, box.func_186670_a(this.field_174879_c), (Predicate)createProjectile.entity.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"world.getEntitiesInAABBe\u2026 { it !is EntityPlayer })");
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((List)list);
        if (entity2 == null) {
            EntityTNTPrimed entityTNTPrimed;
            EntityTNTPrimed $receiver = entityTNTPrimed = new EntityTNTPrimed(this.field_145850_b);
            $receiver.func_184534_a(120);
            entity2 = (Entity)entityTNTPrimed;
        }
        entity2.func_189654_d(true);
        this.projectile = entity2;
        this.setProjectilePosition();
        return entity2;
    }

    private final void doWork() {
        if (this.cooldown == 0) {
            int n;
            TileTrebuchet tileTrebuchet;
            TileTrebuchet tileTrebuchet2 = this;
            if (this.ready) {
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                this.animation.startAnimation(world, true);
                World world2 = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
                this.animation.update(world2, 0.0f);
                this.firing = true;
                this.field_145850_b.func_72838_d(this.createProjectile());
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                TileTrebuchet tileTrebuchet3 = this;
                TileTrebuchet tileTrebuchet4 = tileTrebuchet2;
                NBTTagCompound $receiver = nBTTagCompound;
                $receiver.func_74768_a("event", 1);
                Entity entity2 = this.projectile;
                if (entity2 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.func_74778_a("projectile", entity2.func_110124_au().toString());
                NBTTagCompound nBTTagCompound2 = nBTTagCompound;
                tileTrebuchet = tileTrebuchet4;
                tileTrebuchet3.sendToClient(nBTTagCompound2);
                n = 30;
            } else {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                TileTrebuchet tileTrebuchet5 = this;
                TileTrebuchet tileTrebuchet6 = tileTrebuchet2;
                NBTTagCompound $receiver = nBTTagCompound;
                $receiver.func_74768_a("event", 2);
                NBTTagCompound nBTTagCompound3 = nBTTagCompound;
                tileTrebuchet = tileTrebuchet6;
                tileTrebuchet5.sendToClient(nBTTagCompound3);
                n = 100;
            }
            tileTrebuchet.cooldown = n;
            this.ready = !this.ready;
            this.func_70296_d();
        }
    }

    private final void build(EntityPlayer playerIn) {
        if (playerIn.field_71075_bZ.field_75098_d) {
            this.constructionItems.clear();
            this.func_70296_d();
            this.sendUpdateToNearPlayers();
        } else {
            Collection collection = this.constructionItems.getItems();
            if (!collection.isEmpty()) {
                InvWrapper inv = new InvWrapper((IInventory)playerIn.field_71071_by);
                this.constructionItems.removeFrom((IItemHandler)inv);
                this.func_70296_d();
                this.sendUpdateToNearPlayers();
            }
        }
        if (this.constructionItems.getItems().isEmpty()) {
            BlockPos error = this.checkBlocks();
            if (error == null || playerIn.field_71075_bZ.field_75098_d) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockTrebuchet.Companion.getPROPERTY_ACTIVE(), (Comparable)Boolean.valueOf(true)));
                this.placeBlocks();
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("trebuchet.msg.unable_to_place", new Object[]{"" + '[' + error.func_177958_n() + ',' + error.func_177956_o() + ',' + error.func_177952_p() + ']'}), true);
            }
        }
        this.sendUpdateToNearPlayers();
    }

    public final void onClick(@NotNull IBlockState state, @NotNull EntityPlayer playerIn) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        if (!this.field_145850_b.field_72995_K) {
            Comparable comparable = state.func_177229_b((IProperty)BlockTrebuchet.Companion.getPROPERTY_ACTIVE());
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.getValue(BlockTrebuchet.PROPERTY_ACTIVE)");
            if (((Boolean)comparable).booleanValue()) {
                this.doWork();
            } else {
                this.build(playerIn);
            }
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.func_74757_a("ready", this.ready);
        compound.func_74782_a("constructionItems", (NBTBase)this.constructionItems.serializeNBT());
        NBTTagCompound nBTTagCompound = super.func_189515_b(compound);
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"super.writeToNBT(compound)");
        return nBTTagCompound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        this.ready = compound.func_74767_n("ready");
        NBTTagCompound nBTTagCompound = compound.func_74775_l("constructionItems");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"compound.getCompoundTag(\"constructionItems\")");
        this.constructionItems.deserializeNBT(nBTTagCompound);
        if (this.ready) {
            this.animation.throw1(0.0f);
        } else {
            this.animation.reload1(0.0f);
        }
        super.func_145839_a(compound);
    }

    public double func_145833_n() {
        return 16384.0;
    }

    @NotNull
    public final StackList getConstructionMaterials() {
        StackList stackList;
        StackList $receiver = stackList = new StackList();
        $receiver.add(new ItemStack(Blocks.field_150364_r, 32));
        $receiver.add(new ItemStack(Blocks.field_150344_f, 64));
        $receiver.add(new ItemStack(Blocks.field_150339_S, 2));
        $receiver.add(new ItemStack(Blocks.field_150347_e, 16));
        $receiver.add(new ItemStack(Items.field_151042_j, 16));
        $receiver.add(new ItemStack(Items.field_151007_F, 32));
        return stackList;
    }

    @Nullable
    public final BlockPos checkBlocks() {
        EnumFacing facing = this.getFacing();
        int n = Companion.getScheme().size();
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            int y = i;
            int n3 = Companion.getScheme().get(y).size();
            int n4 = n3;
            for (int j = 0; j < n4; ++j) {
                int z = j;
                int n5 = Companion.getScheme().get(y).get(z).length;
                int n6 = n5;
                for (int k = 0; k < n6; ++k) {
                    IBlockState state;
                    int x = k;
                    if (!Companion.getScheme().get(y).get(z)[x]) continue;
                    BlockPos realPos = this.applyFacing(new BlockPos(x, y, z), facing);
                    BlockPos finalPos = this.field_174879_c.func_177971_a((Vec3i)realPos);
                    IBlockState iBlockState = state = this.field_145850_b.func_180495_p(finalPos);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                    if (iBlockState.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, finalPos)) continue;
                    return finalPos;
                }
            }
        }
        return null;
    }

    public final void placeBlocks() {
        IBlockState state = BlockHolder.INSTANCE.getGap().func_176223_P();
        EnumFacing facing = this.getFacing();
        int n = Companion.getScheme().size();
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            int y = i;
            int n3 = Companion.getScheme().get(y).size();
            int n4 = n3;
            for (int j = 0; j < n4; ++j) {
                int z = j;
                int n5 = Companion.getScheme().get(y).get(z).length;
                int n6 = n5;
                for (int k = 0; k < n6; ++k) {
                    TileGap tileGap;
                    int x = k;
                    if (!Companion.getScheme().get(y).get(z)[x]) continue;
                    BlockPos realPos = this.applyFacing(new BlockPos(x, y, z), facing);
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177971_a((Vec3i)realPos), state);
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)realPos));
                    if (!(tileEntity instanceof TileGap)) {
                        tileEntity = null;
                    }
                    if ((TileGap)tileEntity == null) continue;
                    TileGap it = tileGap;
                    BlockPos blockPos = this.field_174879_c;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                    it.setParentPos(blockPos);
                    it.setFacing(facing);
                    it.sendUpdateToNearPlayers();
                }
            }
        }
    }

    @NotNull
    public final BlockPos applyFacing(@NotNull BlockPos pos, @NotNull EnumFacing facing) {
        BlockPos origin;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        BlockPos center = new BlockPos(2, 0, 0);
        BlockPos blockPos = origin = pos.func_177973_b((Vec3i)center);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"origin");
        BlockPos normalized = UtilKt.rotatePoint(EnumFacing.SOUTH, blockPos);
        return UtilKt.rotatePoint(facing, normalized);
    }

    public final void onStructureBreak(@NotNull EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        if (this.breaking) {
            return;
        }
        this.breaking = true;
        int n = Companion.getScheme().size();
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            int y = i;
            int n3 = Companion.getScheme().get(y).size();
            int n4 = n3;
            for (int j = 0; j < n4; ++j) {
                int z = j;
                int n5 = Companion.getScheme().get(y).get(z).length;
                int n6 = n5;
                for (int k = 0; k < n6; ++k) {
                    int x = k;
                    if (!Companion.getScheme().get(y).get(z)[x]) continue;
                    BlockPos realPos = this.applyFacing(new BlockPos(x, y, z), facing);
                    Block block = Blocks.field_150350_a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.AIR");
                    IBlockState state = block.func_176223_P();
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177971_a((Vec3i)realPos), state);
                }
            }
        }
        Iterable $receiver$iv = this.getConstructionMaterials().getItems();
        for (Object element$iv : $receiver$iv) {
            ItemStack it = (ItemStack)element$iv;
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)it);
        }
        this.breaking = false;
    }

    public final void disable() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockTrebuchet.Companion.getPROPERTY_ACTIVE(), (Comparable)Boolean.valueOf(false)));
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.getActive() && pass == 0) {
            return true;
        }
        return !this.getActive() && pass == 1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_3;
        void $receiver$iv$iv;
        Companion companion = Companion = new Companion(null);
        Object $receiver = companion;
        boolean t = true;
        boolean n = false;
        scheme = CollectionsKt.listOf((Object[])new List[]{CollectionsKt.listOf((Object[])new boolean[][]{{t, t, n, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}, {t, t, t, t, t}}), CollectionsKt.listOf((Object[])new boolean[][]{{t, t, t, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, t, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}}), CollectionsKt.listOf((Object[])new boolean[][]{{n, n, n, n, n}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}}), CollectionsKt.listOf((Object[])new boolean[][]{{n, n, n, n, n}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}}), CollectionsKt.listOf((Object[])new boolean[][]{{n, n, n, n, n}, {n, n, n, n, n}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {t, t, n, t, t}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}}), CollectionsKt.listOf((Object[])new boolean[][]{{n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {t, t, t, t, t}, {t, t, t, t, t}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}}), CollectionsKt.listOf((Object[])new boolean[][]{{n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {t, t, t, t, t}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}, {n, n, n, n, n}})});
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new AxisAlignedBB[]{TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(24.0, 0.0, -23.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(36.0, 8.0, 85.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(26.0, 48.0, -2.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(34.0, 51.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(1.0, 12.5, -24.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(15.0, 17.5, -19.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-18.0, 0.0, 24.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-10.0, 99.0, 32.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-17.0, 2.185, 25.685), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-11.0, 94.815, 118.315), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-17.0, 4.018, -22.098), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-11.0, 95.982, 32.098), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-23.0, 0.0, 176.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(39.0, 3.0, 182.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(15.0, 12.0, -24.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 18.0, -18.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-20.0, 0.0, -23.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-8.0, 8.0, 85.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-20.0, 0.0, 85.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-8.0, 8.0, 193.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(24.0, 0.0, 85.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(36.0, 8.0, 193.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-23.0, 0.0, 144.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(39.0, 3.0, 150.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-23.0, 0.0, 112.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(39.0, 3.0, 118.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-23.0, 0.0, 79.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(39.0, 3.0, 85.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-23.0, 0.0, 48.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(39.0, 3.0, 54.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-23.0, 0.0, -16.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(39.0, 3.0, -10.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(26.0, 0.0, 24.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(34.0, 99.0, 32.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(27.0, 2.185, 25.685), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(33.0, 94.815, 118.315), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(27.0, 4.018, -22.098), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(33.0, 95.982, 32.098), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-18.0, 48.0, -2.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-10.0, 51.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-18.0, 86.0, 18.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-10.0, 91.0, 43.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(26.0, 86.0, 18.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(34.0, 91.0, 43.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-19.0, 91.0, 25.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(35.0, 97.0, 31.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-10.0, 80.0, 24.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-8.0, 98.0, 32.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(24.0, 80.0, 24.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(26.0, 98.0, 32.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-32.0, 0.0, 23.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(48.0, 3.0, 33.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, -32.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, -4.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, -4.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, 24.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, 52.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, 24.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, 52.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, 108.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, 136.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, 80.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, 108.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, 164.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, 192.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 4.0, 136.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 6.0, 164.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, 164.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, 192.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, 136.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, 164.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, 108.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, 136.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, 80.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, 108.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, 52.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, 24.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, 52.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, -4.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, 24.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-0.0, 4.0, -32.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 6.0, -4.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(2.0, 4.0, -32.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(14.0, 6.0, -30.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, -32.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, -16.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, -16.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 0.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 16.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 32.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 0.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 16.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 80.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 96.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 64.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 48.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 64.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 32.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 48.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 144.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 160.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 128.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 144.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 112.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 128.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 96.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 112.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 176.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 192.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 0.0, 160.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 4.0, 176.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-27.631, 1.186, 25.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-14.369, 25.814, 31.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(29.369, 1.186, 25.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(42.631, 25.814, 31.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-31.927, 0.0, 29.643), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-14.073, 2.0, 65.357), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-31.927, -0.0, -9.357), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-14.073, 2.0, 26.357), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(30.073, 0.0, -9.357), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(47.927, 2.0, 26.357), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(30.073, -0.0, 29.643), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(47.927, 2.0, 65.357), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-8.0, 16.0, 72.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(24.0, 24.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-8.0, 0.0, 72.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-4.0, 16.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(20.0, 0.0, 72.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(24.0, 16.0, 80.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-7.0, 2.192, 76.45), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-4.0, 23.808, 117.55), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(20.0, 2.192, 76.45), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(23.0, 23.808, 117.55), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-8.0, 0.0, 111.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 8.0, 119.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(16.0, 0.0, 111.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(24.0, 8.0, 119.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-18.0, 9.607, -26.893), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-10.0, 20.393, -16.107), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(26.0, 9.607, -26.893), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(34.0, 20.393, -16.107), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-20.0, 13.0, -23.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(36.0, 17.0, -19.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-22.0, 11.0, -23.25), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.0, 19.0, -19.75), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-22.0, 10.934, -25.566), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.0, 19.066, -17.434), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-22.0, 13.25, -25.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.0, 16.75, -17.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-22.0, 10.934, -25.566), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.0, 19.066, -17.434), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 9.697, -26.803), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 16.061, -20.439), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 14.5, -28.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 15.5, -20.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 13.939, -26.803), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 20.303, -20.439), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 14.0, -22.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 22.0, -21.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 13.939, -22.561), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 20.303, -16.197), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 14.5, -22.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 15.5, -14.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 9.697, -22.561), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 16.061, -16.197), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(-21.5, 8.0, -22.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(-20.5, 16.0, -21.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(0.0, 12.0, -24.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(1.0, 18.0, -18.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.0, 10.934, -25.566), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(38.0, 19.066, -17.434), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.0, 11.0, -23.25), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(38.0, 19.0, -19.75), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.0, 10.934, -25.566), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(38.0, 19.066, -17.434), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.0, 13.25, -25.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(38.0, 16.75, -17.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 14.5, -28.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 15.5, -20.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 13.939, -26.803), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 20.303, -20.439), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 14.0, -22.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 22.0, -21.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 13.939, -22.561), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 20.303, -16.197), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 14.5, -22.5), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 15.5, -14.5), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 9.697, -22.561), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 16.061, -16.197), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 8.0, -22.0), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 16.0, -21.0), (Number)Float.valueOf(0.0625f))), TileTrebuchet.Companion.to(VectorOperationsKt.times((Vec3d)new Vec3d(36.5, 9.697, -26.803), (Number)Float.valueOf(0.0625f)), VectorOperationsKt.times((Vec3d)new Vec3d(37.5, 16.061, -20.439), (Number)Float.valueOf(0.0625f)))});
        $receiver = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            AxisAlignedBB axisAlignedBB = (AxisAlignedBB)item$iv$iv;
            Collection collection = destination$iv$iv;
            AxisAlignedBB axisAlignedBB2 = it.func_191194_a(VectorConstructorsKt.vec3Of((Number)0, (Number)0, (Number)2));
            collection.add(axisAlignedBB2);
        }
        hitboxes = (List)var2_3;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u000f0\u0006J\u0015\u0010\u0010\u001a\u00020\u0007*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0082\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/cout970/trebuchet/tile/TileTrebuchet$Companion;", "", "()V", "PIXEL", "", "hitboxes", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "kotlin.jvm.PlatformType", "getHitboxes", "()Ljava/util/List;", "scheme", "", "getScheme", "getCollisionBoxes", "Lcom/cout970/trebuchet/AABB;", "to", "Lnet/minecraft/util/math/Vec3d;", "other", "trebuchet"})
    public static final class Companion {
        @NotNull
        public final List<List<boolean[]>> getScheme() {
            return scheme;
        }

        private final AxisAlignedBB to(@NotNull Vec3d $receiver, Vec3d other) {
            return UtilKt.toAABBWith($receiver, other);
        }

        @NotNull
        public final List<AxisAlignedBB> getCollisionBoxes() {
            return this.getHitboxes();
        }

        private final List<AxisAlignedBB> getHitboxes() {
            return hitboxes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

