/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.trebuchet.render;

import com.cout970.trebuchet.render.ModelCache;
import com.cout970.trebuchet.render.ModelCacheKt;
import com.cout970.trebuchet.render.Util;
import com.cout970.trebuchet.render.Util$WhenMappings;
import com.cout970.trebuchet.render.UtilKt;
import com.cout970.trebuchet.tile.TileTrebuchet;
import com.cout970.vector.extensions.VectorConstructorsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J&\u0010\u0015\u001a\u00020\n2\n\u0010\u0016\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0017\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0018\u001a\u00020\bJ&\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ&\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bJ0\u0010)\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u001c2\n\u0010\u0016\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0017\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010*\u001a\u00020\bJ\u001c\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\f\b\u0002\u0010.\u001a\u00060\u0004j\u0002`\u0005J\u0016\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0004J,\u00101\u001a\u00020\n2\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0017\u001a\u00060\u0004j\u0002`\u00052\f\b\u0002\u0010.\u001a\u00060\u0004j\u0002`\u0005J\u000e\u00102\u001a\u00020\n2\u0006\u00103\u001a\u000204J$\u00105\u001a\u00020\n2\b\b\u0002\u0010(\u001a\u0002062\b\b\u0002\u00107\u001a\u0002062\b\b\u0002\u00108\u001a\u000206J\u0018\u00109\u001a\u00020\n2\u0006\u00103\u001a\u0002042\b\b\u0002\u0010:\u001a\u00020\rJ\u0017\u0010;\u001a\u00020\n2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\n0=H\u0086\bJ\u0012\u0010>\u001a\u00020\n2\n\u0010?\u001a\u00060\u0004j\u0002`\u0005J$\u0010>\u001a\u00020\n2\b\b\u0002\u0010(\u001a\u0002062\b\b\u0002\u00107\u001a\u0002062\b\b\u0002\u00108\u001a\u000206\u00a8\u0006@"}, d2={"Lcom/cout970/trebuchet/render/Util;", "", "()V", "collideBottom", "Lnet/minecraft/util/math/Vec3d;", "Lcom/cout970/vector/api/IVector3;", "pos", "bottom", "", "customRotate", "", "rot", "cycleCos", "", "a", "b", "level", "cycleLinear", "drawLine", "t", "Lnet/minecraft/client/renderer/BufferBuilder;", "drawWireBetween", "start", "end", "weight", "expInterp", "exp", "getGroup", "", "Lcom/cout970/trebuchet/render/ModelCache;", "loc", "Lnet/minecraft/client/renderer/block/model/ModelResourceLocation;", "code", "", "getNonGroup", "interp", "interpolate", "fa", "fb", "fc", "x", "interpolateWire", "mass", "renderBox", "box", "Lnet/minecraft/util/math/AxisAlignedBB;", "color", "renderFloatingLabel", "str", "renderLine", "renderMultiblockHitboxes", "facing", "Lnet/minecraft/util/EnumFacing;", "rotate", "", "y", "z", "rotateFromCenter", "optional", "stackMatrix", "func", "Lkotlin/Function0;", "translate", "vec", "trebuchet"})
public final class Util {
    public static final Util INSTANCE;

    public final void renderLine(@NotNull Vec3d pos, @NotNull Vec3d end, @NotNull Vec3d color) {
        Tessellator tes;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Tessellator tessellator = tes = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator, (String)"tes");
        BufferBuilder t = tessellator.func_178180_c();
        float r = (float)color.field_72450_a;
        float g = (float)color.field_72448_b;
        float b = (float)color.field_72449_c;
        float a = 1.0f;
        GL11.glDisable((int)3553);
        GlStateManager.func_187441_d((float)2.0f);
        t.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        t.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181666_a(r, g, b, a).func_181675_d();
        tes.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static /* bridge */ /* synthetic */ void renderLine$default(Util util, Vec3d vec3d, Vec3d vec3d2, Vec3d vec3d3, int n, Object object) {
        if ((n & 4) != 0) {
            vec3d3 = VectorConstructorsKt.vec3Of((Number)1, (Number)1, (Number)1);
        }
        util.renderLine(vec3d, vec3d2, vec3d3);
    }

    public final float interp(float a, float b, float level) {
        return a + (b - a) * level;
    }

    public final float expInterp(float a, float b, float exp, float level) {
        double max = Math.pow(exp, 1.0);
        double min = Math.pow(exp, 0.0);
        double e = (Math.pow(exp, level) - min) / (max - min);
        return a + (b - a) * (float)e;
    }

    public final float cycleLinear(float a, float b, float level) {
        return (double)level < 0.5 ? this.interp(a, b, level * 2.0f) : this.interp(b, a, (level - 0.5f) * 2.0f);
    }

    public final float cycleCos(float a, float b, float level) {
        return this.interp(a, b, (float)Math.cos((double)level * (double)UtilKt.getRads(360)) * 0.5f + 1.0f);
    }

    public final void customRotate(@NotNull Vec3d rot, @NotNull Vec3d pos) {
        Intrinsics.checkParameterIsNotNull((Object)rot, (String)"rot");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.translate(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.rotate(Float.valueOf((float)rot.field_72450_a), Float.valueOf((float)rot.field_72448_b), Float.valueOf((float)rot.field_72449_c));
        this.translate(-pos.field_72450_a, -pos.field_72448_b, -pos.field_72449_c);
    }

    public final void stackMatrix(@NotNull Function0<Unit> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        GlStateManager.func_179094_E();
        func.invoke();
        GlStateManager.func_179121_F();
    }

    @NotNull
    public final Vec3d collideBottom(@NotNull Vec3d pos, double bottom) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        double d = pos.field_72448_b;
        Number number = pos.field_72450_a;
        double d2 = Math.max(bottom, d);
        return VectorConstructorsKt.vec3Of((Number)number, (Number)d2, (Number)pos.field_72449_c);
    }

    public final void translate(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull((Object)y, (String)"y");
        Intrinsics.checkParameterIsNotNull((Object)z, (String)"z");
        GlStateManager.func_179109_b((float)x.floatValue(), (float)y.floatValue(), (float)z.floatValue());
    }

    public static /* bridge */ /* synthetic */ void translate$default(Util util, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 1) != 0) {
            number = Float.valueOf(0.0f);
        }
        if ((n & 2) != 0) {
            number2 = Float.valueOf(0.0f);
        }
        if ((n & 4) != 0) {
            number3 = Float.valueOf(0.0f);
        }
        util.translate(number, number2, number3);
    }

    public final void translate(@NotNull Vec3d vec) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        GlStateManager.func_179137_b((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
    }

    public final void rotate(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull((Object)y, (String)"y");
        Intrinsics.checkParameterIsNotNull((Object)z, (String)"z");
        GlStateManager.func_179114_b((float)x.floatValue(), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)y.floatValue(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)z.floatValue(), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static /* bridge */ /* synthetic */ void rotate$default(Util util, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 1) != 0) {
            number = Float.valueOf(0.0f);
        }
        if ((n & 2) != 0) {
            number2 = Float.valueOf(0.0f);
        }
        if ((n & 4) != 0) {
            number3 = Float.valueOf(0.0f);
        }
        util.rotate(number, number2, number3);
    }

    @NotNull
    public final List<ModelCache> getNonGroup(@NotNull ModelResourceLocation loc) {
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        return ModelCacheKt.createMultiTextureCache(loc, (Function1<? super String, Boolean>)((Function1)getNonGroup.1.INSTANCE));
    }

    @NotNull
    public final List<ModelCache> getGroup(@NotNull ModelResourceLocation loc, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        return ModelCacheKt.createMultiTextureCache(loc, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(code){
            final /* synthetic */ String $code;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StringsKt.contains$default((CharSequence)it, (CharSequence)('[' + this.$code + ']'), (boolean)false, (int)2, null);
            }
            {
                this.$code = string;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void drawWireBetween(@NotNull Vec3d start, @NotNull Vec3d end, double weight) {
        Tessellator tes;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Tessellator tessellator = tes = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator, (String)"tes");
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        List<Vec3d> points = this.interpolateWire(start, end, weight);
        int n = 0;
        int n2 = points.size() - 2;
        if (n <= n2) {
            while (true) {
                void p;
                BufferBuilder bufferBuilder = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferBuilder, (String)"buffer");
                this.drawLine(bufferBuilder, points.get((int)p), points.get((int)(p + true)));
                if (p == n2) break;
                ++p;
            }
        }
        tes.func_78381_a();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vec3d> interpolateWire(@NotNull Vec3d start, @NotNull Vec3d end, double mass) {
        Vec3d $receiver$iv;
        Vec3d vec3d;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        List list = new ArrayList();
        double distance = start.func_72438_d(end);
        Vec3d vec3d2 = start;
        Vec3d vec3d3 = vec3d;
        Object object = vec3d;
        double d = $receiver$iv.field_72450_a;
        $receiver$iv = end;
        double d2 = $receiver$iv.field_72450_a;
        $receiver$iv = start;
        d = (d + d2) / (double)2;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = end;
        double d3 = $receiver$iv.field_72448_b;
        $receiver$iv = start;
        d2 = (d2 + d3) / (double)2 - distance * mass;
        d3 = $receiver$iv.field_72449_c;
        $receiver$iv = end;
        double d4 = $receiver$iv.field_72449_c;
        vec3d3(d, d2, (d3 + d4) / (double)2);
        Vec3d middle = object;
        int $receiver$iv2 = 0;
        int n = 10;
        while ($receiver$iv2 <= n) {
            Vec3d $receiver$iv3;
            Vec3d $receiver$iv4;
            Vec3d $receiver$iv5;
            void i;
            double p = (double)i / 10.0;
            Vec3d vec3d4 = start;
            object = this;
            double d5 = $receiver$iv5.field_72450_a;
            $receiver$iv5 = middle;
            double d6 = $receiver$iv5.field_72450_a;
            $receiver$iv5 = end;
            double d7 = $receiver$iv5.field_72450_a;
            double x = ((Util)object).interpolate(d5, d6, d7, p);
            Vec3d vec3d5 = start;
            object = this;
            d5 = $receiver$iv4.field_72448_b;
            $receiver$iv4 = middle;
            d6 = $receiver$iv4.field_72448_b;
            $receiver$iv4 = end;
            d7 = $receiver$iv4.field_72448_b;
            double y = ((Util)object).interpolate(d5, d6, d7, p);
            Vec3d vec3d6 = start;
            object = this;
            d5 = $receiver$iv3.field_72449_c;
            $receiver$iv3 = middle;
            d6 = $receiver$iv3.field_72449_c;
            $receiver$iv3 = end;
            d7 = $receiver$iv3.field_72449_c;
            double z = ((Util)object).interpolate(d5, d6, d7, p);
            list.add(new Vec3d(x, y, z));
            ++i;
        }
        return list;
    }

    public final double interpolate(double fa, double fb, double fc, double x) {
        double a = 0.0;
        double b = 0.5;
        double c = 1.0;
        double L0 = (x - b) / (a - b) * ((x - c) / (a - c));
        double L1 = (x - a) / (b - a) * ((x - c) / (b - c));
        double L2 = (x - a) / (c - a) * ((x - b) / (c - b));
        return fa * L0 + fb * L1 + fc * L2;
    }

    public final void drawLine(@NotNull BufferBuilder t, @NotNull Vec3d a, @NotNull Vec3d b) {
        Vec3d $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        double w = 0.03125;
        Vec3d vec3d = a;
        BufferBuilder bufferBuilder = t;
        double d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        double d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        double d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 -= w, d3).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 += w, d3).func_187315_a(0.125, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 += w, d3).func_187315_a(0.125, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 -= w, d3).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 - w).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 + w).func_187315_a(0.125, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 + w).func_187315_a(0.125, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 - w).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d -= w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d += w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.125, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d += w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.125, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d -= w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 += w, d3).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 -= w, d3).func_187315_a(0.125, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 -= w, d3).func_187315_a(0.125, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2 += w, d3).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 + w).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 - w).func_187315_a(0.125, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 - w).func_187315_a(0.125, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3 + w).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d += w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = a;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = a;
        d -= w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = a;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.125, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d -= w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.125, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        $receiver$iv = b;
        bufferBuilder = t;
        d = $receiver$iv.field_72450_a;
        $receiver$iv = b;
        d += w;
        d2 = $receiver$iv.field_72448_b;
        $receiver$iv = b;
        d3 = $receiver$iv.field_72449_c;
        bufferBuilder.func_181662_b(d, d2, d3).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public final void rotateFromCenter(@NotNull EnumFacing facing, float optional) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        switch (Util$WhenMappings.$EnumSwitchMapping$0[facing.ordinal()]) {
            case 1: {
                f = 0.0f;
                break;
            }
            case 2: {
                f = 180.0f;
                break;
            }
            case 3: {
                f = 90.0f;
                break;
            }
            case 4: {
                f = -90.0f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        float angle = f + optional;
        this.translate(0.5, 0.5, 0.5);
        this.rotate(Float.valueOf(0.0f), Float.valueOf(angle), Float.valueOf(0.0f));
        this.translate(-0.5, -0.5, -0.5);
    }

    public static /* bridge */ /* synthetic */ void rotateFromCenter$default(Util util, EnumFacing enumFacing, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        util.rotateFromCenter(enumFacing, f);
    }

    public final void renderFloatingLabel(@NotNull String str, @NotNull Vec3d pos) {
        Tessellator tessellator;
        RenderManager renderManager;
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        RenderManager renderManager2 = renderManager = minecraft.func_175598_ae();
        Intrinsics.checkExpressionValueIsNotNull((Object)renderManager2, (String)"renderManager");
        FontRenderer fontrenderer = renderManager2.func_78716_a();
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        this.translate(Float.valueOf((float)x + 0.0f), Float.valueOf((float)y + 0.5f), Float.valueOf((float)z));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
        BufferBuilder worldrenderer = tessellator2.func_178180_c();
        int i = 0;
        int j = fontrenderer.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - void declaration
     */
    public final void renderMultiblockHitboxes(@NotNull EnumFacing facing) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        Iterable $receiver$iv = TileTrebuchet.Companion.getCollisionBoxes();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            AxisAlignedBB axisAlignedBB = (AxisAlignedBB)item$iv$iv;
            Collection collection = destination$iv$iv;
            AxisAlignedBB origin = UtilKt.rotateBox(EnumFacing.SOUTH, VectorConstructorsKt.vec3Of((Number)0.5), (AxisAlignedBB)it);
            AxisAlignedBB axisAlignedBB2 = UtilKt.rotateBox(facing, VectorConstructorsKt.vec3Of((Number)0.5), origin);
            collection.add(axisAlignedBB2);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            AxisAlignedBB it = (AxisAlignedBB)element$iv;
            Util.renderBox$default(INSTANCE, it, null, 2, null);
        }
    }

    public final void renderBox(@NotNull AxisAlignedBB box, @NotNull Vec3d color) {
        Tessellator tes;
        Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Tessellator tessellator = tes = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator, (String)"tes");
        BufferBuilder t = tessellator.func_178180_c();
        Vec3d $receiver$iv = color;
        float r = (float)$receiver$iv.field_72450_a;
        Vec3d $receiver$iv2 = color;
        float g = (float)$receiver$iv2.field_72448_b;
        Vec3d $receiver$iv3 = color;
        float b = (float)$receiver$iv3.field_72449_c;
        float a = 1.0f;
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_187441_d((float)2.0f);
        t.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        t.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        t.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        tes.func_78381_a();
    }

    public static /* bridge */ /* synthetic */ void renderBox$default(Util util, AxisAlignedBB axisAlignedBB, Vec3d vec3d, int n, Object object) {
        if ((n & 2) != 0) {
            vec3d = VectorConstructorsKt.vec3Of((Number)1, (Number)1, (Number)1);
        }
        util.renderBox(axisAlignedBB, vec3d);
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

