/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.trebuchet.render;

import com.cout970.trebuchet.render.Kinematic;
import com.cout970.trebuchet.render.TrebuchetAnimation;
import com.cout970.trebuchet.render.Util;
import com.cout970.trebuchet.render.UtilKt;
import com.cout970.vector.extensions.VectorConstructorsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000212B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H\u0016J\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u0002H\u0016J\u0016\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0013J\u000e\u0010-\u001a\u00020#2\u0006\u0010&\u001a\u00020'J\u000e\u0010.\u001a\u00020#2\u0006\u0010&\u001a\u00020'J\u0016\u0010/\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u001e\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007\u00a8\u00063"}, d2={"Lcom/cout970/trebuchet/render/TrebuchetAnimation;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagCompound;", "()V", "barKinematic", "Lcom/cout970/trebuchet/render/Kinematic;", "getBarKinematic", "()Lcom/cout970/trebuchet/render/Kinematic;", "currentTrack", "Lcom/cout970/trebuchet/render/TrebuchetAnimation$AnimationTrack;", "getCurrentTrack", "()Lcom/cout970/trebuchet/render/TrebuchetAnimation$AnimationTrack;", "setCurrentTrack", "(Lcom/cout970/trebuchet/render/TrebuchetAnimation$AnimationTrack;)V", "handleKinematic", "getHandleKinematic", "inverseBarKinematic", "getInverseBarKinematic", "isActive", "", "()Z", "massKinematic", "getMassKinematic", "returnWireKinematic", "Lnet/minecraft/util/math/Vec3d;", "Lcom/cout970/vector/api/IVector3;", "getReturnWireKinematic", "()Lnet/minecraft/util/math/Vec3d;", "setReturnWireKinematic", "(Lnet/minecraft/util/math/Vec3d;)V", "startTick", "", "wireKinematic", "getWireKinematic", "deserializeNBT", "", "nbt", "reload1", "time", "", "serializeNBT", "startAnimation", "world", "Lnet/minecraft/world/World;", "isThrow", "throw1", "throw2", "update", "partialTicks", "AnimationTrack", "Companion", "trebuchet"})
public final class TrebuchetAnimation
implements INBTSerializable<NBTTagCompound> {
    @NotNull
    private final Kinematic barKinematic = new Kinematic(VectorConstructorsKt.vec3Of((Number)0.5, (Number)(6.0 - (double)UtilKt.getPx(2)), (Number)(1.5 + (double)UtilKt.getPx(4))), VectorConstructorsKt.vec3Of((Number)0.0, (Number)0.0, (Number)(10.5 + (double)UtilKt.getPx(2))), VectorConstructorsKt.vec3Of((Number)Float.valueOf(UtilKt.getRads(27)), (Number)0.0, (Number)0.0));
    @NotNull
    private final Kinematic inverseBarKinematic = new Kinematic(VectorConstructorsKt.vec3Of((Number)0.5, (Number)(6.0 - (double)UtilKt.getPx(2)), (Number)(1.5 + (double)UtilKt.getPx(4))), VectorConstructorsKt.vec3Of((Number)0.0, (Number)0.0, (Number)-3.125), VectorConstructorsKt.vec3Of((Number)Float.valueOf(UtilKt.getRads(27)), (Number)0.0, (Number)0.0));
    @NotNull
    private final Kinematic massKinematic = new Kinematic(VectorConstructorsKt.vec3Of((Number)0.5, (Number)(6.0 - (double)UtilKt.getPx(2)), (Number)(-1.5 + (double)UtilKt.getPx(2))), VectorConstructorsKt.vec3Of((Number)0.0, (Number)-1.0, (Number)0.0), VectorConstructorsKt.vec3Of((Number)0.0, (Number)0.0, (Number)0.0));
    @NotNull
    private final Kinematic wireKinematic = new Kinematic(VectorConstructorsKt.vec3Of((Number)0.0), VectorConstructorsKt.vec3Of((Number)0.0, (Number)-0.5, (Number)-7.0), VectorConstructorsKt.vec3Of((Number)0.0, (Number)0.0, (Number)0.0));
    @NotNull
    private final Kinematic handleKinematic = new Kinematic(VectorConstructorsKt.vec3Of((Number)0.5, (Number)(1.0 - (double)UtilKt.getPx(1)), (Number)(-1.0 - UtilKt.getPx(5.5))), VectorConstructorsKt.vec3Of((Number)0.0, (Number)0.0, (Number)1.0), VectorConstructorsKt.vec3Of((Number)0.0, (Number)0.0, (Number)0.0));
    @NotNull
    private Vec3d returnWireKinematic = VectorConstructorsKt.vec3Of((Number)0.5, (Number)(1.0 - (double)UtilKt.getPx(1)), (Number)5.0);
    private long startTick;
    @NotNull
    private AnimationTrack currentTrack;
    @NotNull
    private static final AnimationTrack throwTrack;
    @NotNull
    private static final AnimationTrack realoadTrack;
    public static final Companion Companion;

    @NotNull
    public final Kinematic getBarKinematic() {
        return this.barKinematic;
    }

    @NotNull
    public final Kinematic getInverseBarKinematic() {
        return this.inverseBarKinematic;
    }

    @NotNull
    public final Kinematic getMassKinematic() {
        return this.massKinematic;
    }

    @NotNull
    public final Kinematic getWireKinematic() {
        return this.wireKinematic;
    }

    @NotNull
    public final Kinematic getHandleKinematic() {
        return this.handleKinematic;
    }

    @NotNull
    public final Vec3d getReturnWireKinematic() {
        return this.returnWireKinematic;
    }

    public final void setReturnWireKinematic(@NotNull Vec3d vec3d) {
        Intrinsics.checkParameterIsNotNull((Object)vec3d, (String)"<set-?>");
        this.returnWireKinematic = vec3d;
    }

    @NotNull
    public final AnimationTrack getCurrentTrack() {
        return this.currentTrack;
    }

    public final void setCurrentTrack(@NotNull AnimationTrack animationTrack) {
        Intrinsics.checkParameterIsNotNull((Object)animationTrack, (String)"<set-?>");
        this.currentTrack = animationTrack;
    }

    public final boolean isActive() {
        return this.startTick != -1L;
    }

    public final void update(@NotNull World world, float partialTicks) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        if (this.startTick == -1L) {
            return;
        }
        long ticks = world.func_82737_E() - this.startTick;
        if ((float)ticks > this.currentTrack.getTotalDuration()) {
            this.startTick = -1L;
            return;
        }
        float globalTime = (float)ticks + partialTicks;
        for (Pair<Float, Function2<TrebuchetAnimation, Float, Unit>> pair : this.currentTrack.getTrack()) {
            float duration = ((Number)pair.component1()).floatValue();
            Function2 func = (Function2)pair.component2();
            if (globalTime - duration <= 0.0f) {
                func.invoke((Object)this, (Object)Float.valueOf(globalTime / duration));
                return;
            }
            globalTime -= duration;
        }
    }

    public final void startAnimation(@NotNull World world, boolean isThrow) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        this.startTick = world.func_82737_E();
        this.currentTrack = isThrow ? Companion.getThrowTrack() : Companion.getRealoadTrack();
    }

    public final void throw1(float time) {
        this.barKinematic.withXrot(Util.INSTANCE.expInterp(UtilKt.getRads(27), UtilKt.getRads(-90), 9.8f, time));
        this.massKinematic.withXrot(Util.INSTANCE.expInterp(UtilKt.getRads(-22), UtilKt.getRads(90), 9.8f, time));
        this.wireKinematic.withXrot(Util.INSTANCE.expInterp(UtilKt.getRads(360), UtilKt.getRads(90), 9.8f, time));
        this.inverseBarKinematic.setAngles(this.barKinematic.getAngles());
        this.wireKinematic.setStart(this.barKinematic.getEnd());
        float f = (float)this.wireKinematic.getEnd().field_72448_b;
        float f2 = UtilKt.getPx(5.5f);
        f = Math.max(f, f2);
        f2 = UtilKt.getPx(15);
        float y = Math.min(f, f2);
        float z = y >= UtilKt.getPx(15) ? 5.0f : (float)this.wireKinematic.getEnd().field_72449_c;
        this.returnWireKinematic = VectorConstructorsKt.vec3Of((Number)0.5, (Number)Float.valueOf(y), (Number)Float.valueOf(z));
    }

    public final void throw2(float time) {
        float newTime;
        float center = -90.0f;
        float maxDiff = 60.0f;
        float f = time * UtilKt.getRads(360);
        float f2 = center;
        float f3 = (float)Math.sin(f);
        float angle = f2 - f3 * (maxDiff * (1.0f - time));
        this.barKinematic.withXrot(UtilKt.getRads(Float.valueOf(angle)));
        this.massKinematic.withXrot(-UtilKt.getRads(Float.valueOf(angle)));
        if (time < 0.25f) {
            newTime = time * 4.0f;
            this.wireKinematic.withXrot(UtilKt.getRads(Float.valueOf(Util.INSTANCE.interp(90.0f, -90.0f, newTime))));
        } else {
            newTime = (time - 0.25f) * 1.3333334f;
            float f4 = newTime * UtilKt.getRads(360);
            f2 = -90;
            f3 = (float)Math.sin(f4);
            float newAngle = f2 - f3 * (maxDiff * (1.0f - newTime));
            this.wireKinematic.withXrot(UtilKt.getRads(Float.valueOf(newAngle)));
        }
        this.inverseBarKinematic.setAngles(this.barKinematic.getAngles());
        this.wireKinematic.setStart(this.barKinematic.getEnd());
    }

    public final void reload1(float time) {
        float newTime;
        this.handleKinematic.withXrot(time * UtilKt.getRads(360) * (float)5);
        this.barKinematic.withXrot(UtilKt.getRads(Float.valueOf(Util.INSTANCE.interp(-90.0f, 27.0f, time))));
        this.massKinematic.withXrot(UtilKt.getRads(Float.valueOf(Util.INSTANCE.interp(90.0f, -22.0f, time))));
        if (time > UtilKt.getPx(14)) {
            newTime = (time - UtilKt.getPx(14)) / UtilKt.getPx(2);
            this.returnWireKinematic = VectorConstructorsKt.vec3Of((Number)0.5, (Number)Float.valueOf(Util.INSTANCE.interp(UtilKt.getPx(15), UtilKt.getPx(8), newTime)), (Number)Float.valueOf(Util.INSTANCE.interp(5.0f, 3.9f, newTime)));
        } else {
            this.returnWireKinematic = VectorConstructorsKt.vec3Of((Number)0.5, (Number)Float.valueOf(UtilKt.getPx(15)), (Number)Float.valueOf(5.0f));
        }
        if (time < 0.5f) {
            newTime = time * 2.0f;
            this.wireKinematic.withXrot(UtilKt.getRads(Float.valueOf(Util.INSTANCE.interp(-90.0f, -67.5f, newTime))));
        } else {
            newTime = (time - 0.5f) * 2.0f;
            this.wireKinematic.withXrot(UtilKt.getRads(Float.valueOf(Util.INSTANCE.interp(-67.5f, 0.0f, newTime))));
        }
        this.inverseBarKinematic.setAngles(this.barKinematic.getAngles());
        this.wireKinematic.setStart(this.barKinematic.getEnd());
    }

    public void deserializeNBT(@NotNull NBTTagCompound nbt) {
        AnimationTrack animationTrack;
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        this.startTick = nbt.func_74763_f("start");
        if (nbt.func_74767_n("currentTrack")) {
            this.throw1(0.0f);
            animationTrack = Companion.getThrowTrack();
        } else {
            this.reload1(0.0f);
            animationTrack = Companion.getRealoadTrack();
        }
        this.currentTrack = animationTrack;
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nBTTagCompound;
        NBTTagCompound $receiver = nBTTagCompound = new NBTTagCompound();
        $receiver.func_74772_a("start", this.startTick);
        $receiver.func_74757_a("currentTrack", Intrinsics.areEqual((Object)this.currentTrack, (Object)Companion.getThrowTrack()));
        return nBTTagCompound;
    }

    public TrebuchetAnimation() {
        this.throw1(0.0f);
        this.startTick = -1L;
        this.currentTrack = Companion.getThrowTrack();
    }

    static {
        Companion = new Companion(null);
        throwTrack = new AnimationTrack(CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)Float.valueOf(30.0f), (Object)((Object)Companion.throwTrack.1.INSTANCE)), TuplesKt.to((Object)Float.valueOf(40.0f), (Object)((Object)Companion.throwTrack.2.INSTANCE))}));
        realoadTrack = new AnimationTrack(CollectionsKt.listOf((Object)TuplesKt.to((Object)Float.valueOf(100.0f), (Object)((Object)Companion.realoadTrack.1.INSTANCE))));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B6\u0012/\u0010\u0002\u001a+\u0012'\u0012%\u0012\u0004\u0012\u00020\u0005\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t0\u00040\u0003\u00a2\u0006\u0002\u0010\nJ2\u0010\u0010\u001a+\u0012'\u0012%\u0012\u0004\u0012\u00020\u0005\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t0\u00040\u0003H\u00c6\u0003J<\u0010\u0011\u001a\u00020\u000021\b\u0002\u0010\u0002\u001a+\u0012'\u0012%\u0012\u0004\u0012\u00020\u0005\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t0\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR:\u0010\u0002\u001a+\u0012'\u0012%\u0012\u0004\u0012\u00020\u0005\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t0\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/cout970/trebuchet/render/TrebuchetAnimation$AnimationTrack;", "", "track", "", "Lkotlin/Pair;", "", "Lkotlin/Function2;", "Lcom/cout970/trebuchet/render/TrebuchetAnimation;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/util/List;)V", "totalDuration", "getTotalDuration", "()F", "getTrack", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "trebuchet"})
    public static final class AnimationTrack {
        private final float totalDuration;
        @NotNull
        private final List<Pair<Float, Function2<TrebuchetAnimation, Float, Unit>>> track;

        public final float getTotalDuration() {
            return this.totalDuration;
        }

        @NotNull
        public final List<Pair<Float, Function2<TrebuchetAnimation, Float, Unit>>> getTrack() {
            return this.track;
        }

        /*
         * WARNING - void declaration
         */
        public AnimationTrack(@NotNull List<? extends Pair<Float, ? extends Function2<? super TrebuchetAnimation, ? super Float, Unit>>> track) {
            Collection<Float> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(track, (String)"track");
            this.track = track;
            Iterable iterable = this.track;
            AnimationTrack animationTrack = this;
            void var3_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                Float f = Float.valueOf(((Number)it.getFirst()).floatValue());
                collection.add(f);
            }
            collection = (List)destination$iv$iv;
            animationTrack.totalDuration = CollectionsKt.sumOfFloat((Iterable)collection);
        }

        @NotNull
        public final List<Pair<Float, Function2<TrebuchetAnimation, Float, Unit>>> component1() {
            return this.track;
        }

        @NotNull
        public final AnimationTrack copy(@NotNull List<? extends Pair<Float, ? extends Function2<? super TrebuchetAnimation, ? super Float, Unit>>> track) {
            Intrinsics.checkParameterIsNotNull(track, (String)"track");
            return new AnimationTrack(track);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ AnimationTrack copy$default(AnimationTrack animationTrack, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = animationTrack.track;
            }
            return animationTrack.copy(list);
        }

        public String toString() {
            return "AnimationTrack(track=" + this.track + ")";
        }

        public int hashCode() {
            List<Pair<Float, Function2<TrebuchetAnimation, Float, Unit>>> list = this.track;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AnimationTrack)) break block3;
                    AnimationTrack animationTrack = (AnimationTrack)object;
                    if (!Intrinsics.areEqual(this.track, animationTrack.track)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cout970/trebuchet/render/TrebuchetAnimation$Companion;", "", "()V", "realoadTrack", "Lcom/cout970/trebuchet/render/TrebuchetAnimation$AnimationTrack;", "getRealoadTrack", "()Lcom/cout970/trebuchet/render/TrebuchetAnimation$AnimationTrack;", "throwTrack", "getThrowTrack", "trebuchet"})
    public static final class Companion {
        @NotNull
        public final AnimationTrack getThrowTrack() {
            return throwTrack;
        }

        @NotNull
        public final AnimationTrack getRealoadTrack() {
            return realoadTrack;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

