/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.globe.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import me.ichun.mods.globe.common.Globe;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.lang3.RandomStringUtils;

public class TileEntityGlobeCreator
extends TileEntity
implements ITickable {
    public static final int GLOBE_TIME = 200;
    public static final DamageSource ds = new DamageSource("globe.globeProcess").func_76348_h();
    public boolean hasGlobe;
    public int timeToGlobe = -1;
    public int totalGlobeTime = 0;
    public int radius = 5;
    public NBTTagCompound itemTag = new NBTTagCompound();
    public HashMap<String, TileEntity> renderingTEs;
    public HashSet<Entity> renderingEnts;
    public boolean globed;
    public int lastLight;
    public static boolean soundCached;

    public void func_73660_a() {
        if (!soundCached && this.field_145850_b.field_72995_K) {
            soundCached = true;
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, Globe.soundChargeup, SoundCategory.BLOCKS, 5.0E-4f, 1.0f);
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, Globe.soundDing, SoundCategory.BLOCKS, 5.0E-4f, 1.0f);
        }
        if (this.timeToGlobe > 0) {
            --this.timeToGlobe;
            if (this.timeToGlobe == 12) {
                if (!this.field_145850_b.field_72995_K) {
                    BlockPos refPos;
                    IBlockState state;
                    int x;
                    this.itemTag.func_74768_a("radius", this.radius);
                    List entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)this.radius, (double)this.radius, (double)this.radius));
                    int playerCount = 0;
                    int entityCount = 0;
                    for (Entity ent : entities) {
                        NBTTagCompound tag;
                        if (ent instanceof EntityPlayer) {
                            if (ent instanceof FakePlayer) continue;
                            tag = new NBTTagCompound();
                            ent.func_189511_e(tag);
                            NBTTagCompound nbttagcompound = new NBTTagCompound();
                            NBTUtil.func_180708_a((NBTTagCompound)nbttagcompound, (GameProfile)((EntityPlayer)ent).func_146103_bH());
                            tag.func_74782_a("Globe_GamePlofile", (NBTBase)nbttagcompound);
                            this.itemTag.func_74782_a("player" + playerCount, (NBTBase)tag);
                            ++playerCount;
                            if (((EntityPlayer)ent).field_71075_bZ.field_75098_d || ((EntityPlayer)ent).func_175149_v()) continue;
                            ent.func_70097_a(ds, 1000000.0f);
                            continue;
                        }
                        tag = new NBTTagCompound();
                        if (!ent.func_70039_c(tag)) continue;
                        this.itemTag.func_74782_a("ent" + entityCount, (NBTBase)tag);
                        ++entityCount;
                    }
                    this.itemTag.func_74768_a("playerCount", playerCount);
                    this.itemTag.func_74768_a("entityCount", entityCount);
                    for (x = -this.radius; x <= this.radius; ++x) {
                        for (int y = -this.radius; y <= this.radius; ++y) {
                            for (int z = -this.radius; z <= this.radius; ++z) {
                                TileEntity te;
                                if (x == 0 && y == 0 && z == 0 || (state = this.field_145850_b.func_180495_p(refPos = this.func_174877_v().func_177982_a(x, y, z))).func_185904_a() == Material.field_151579_a || state.func_185887_b(this.field_145850_b, refPos) < 0.0f) continue;
                                StringBuilder sb = new StringBuilder().append("x").append(x).append("y").append(y).append("z").append(z);
                                String coord = sb.toString();
                                NBTTagCompound coordTag = new NBTTagCompound();
                                Block block = state.func_177230_c();
                                ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
                                coordTag.func_74778_a("Block", resourcelocation.toString());
                                coordTag.func_74774_a("Data", (byte)state.func_177230_c().func_176201_c(state));
                                if (block.hasTileEntity(state) && (te = this.field_145850_b.func_175625_s(refPos)) != null) {
                                    coordTag.func_74782_a("TileEntityData", (NBTBase)te.func_189515_b(new NBTTagCompound()));
                                }
                                this.itemTag.func_74782_a(coord, (NBTBase)coordTag);
                            }
                        }
                    }
                    for (x = -this.radius; x <= this.radius; ++x) {
                        for (int y = -this.radius; y <= this.radius; ++y) {
                            for (int z = -this.radius; z <= this.radius; ++z) {
                                if (x == 0 && y == 0 && z == 0 || (state = this.field_145850_b.func_180495_p(refPos = this.func_174877_v().func_177982_a(x, y, z))).func_185904_a() == Material.field_151579_a || state.func_185887_b(this.field_145850_b, refPos) < 0.0f) continue;
                                this.field_145850_b.func_175698_g(refPos);
                            }
                        }
                    }
                    entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)this.radius, (double)this.radius, (double)this.radius));
                    for (Entity ent : entities) {
                        if (ent instanceof EntityPlayer) continue;
                        ent.func_70106_y();
                    }
                    IBlockState state2 = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, state2, state2, 3);
                }
            } else if (this.timeToGlobe == 0) {
                this.globed = true;
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack is = new ItemStack(Globe.itemGlobe, 1, 1);
                    this.itemTag.func_74778_a("identification", RandomStringUtils.randomAlphanumeric((int)20));
                    this.itemTag.func_74772_a("source", this.func_174877_v().func_177986_g());
                    is.func_77982_d(this.itemTag);
                    EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, is);
                    entityitem.func_174867_a(40);
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, Globe.soundDing, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            if (this.field_145850_b.field_72995_K) {
                int newLight = Globe.blockGlobeCreator.getLightValue(this.field_145850_b.func_180495_p(this.field_174879_c), (IBlockAccess)this.field_145850_b, this.field_174879_c);
                if (newLight != this.lastLight) {
                    this.field_145850_b.func_175664_x(this.field_174879_c);
                }
                this.lastLight = newLight;
            }
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("hasGlobe", this.hasGlobe);
        tag.func_74768_a("timeToGlobe", this.timeToGlobe);
        tag.func_74768_a("totalGlobeTime", this.totalGlobeTime);
        tag.func_74768_a("radius", this.radius);
        tag.func_74782_a("itemTag", (NBTBase)this.itemTag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.hasGlobe = tag.func_74767_n("hasGlobe");
        this.timeToGlobe = tag.func_74762_e("timeToGlobe");
        this.totalGlobeTime = tag.func_74762_e("totalGlobeTime");
        this.radius = tag.func_74762_e("radius");
        this.itemTag = tag.func_74775_l("itemTag");
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && this.timeToGlobe < 0 || pass == 1 && this.timeToGlobe >= 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.timeToGlobe < 0) {
            return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -this.radius, -this.radius), this.field_174879_c.func_177982_a(this.radius + 1, this.radius + 1, this.radius + 1));
    }
}

