/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates.ingredients.providers.entities;

import com.minemaarten.templatewands.api.TemplateWands;
import com.minemaarten.templatewands.api.ingredients.IEntityIngredientProvider;
import com.minemaarten.templatewands.api.ingredients.IIngredientList;
import com.minemaarten.templatewands.api.util.EntityContext;
import com.minemaarten.templatewands.templates.ingredients.providers.blocks.ProviderInventoryContents;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@TemplateWands
public class ProviderEntitySpecials
implements IEntityIngredientProvider {
    private final Map<Class<? extends Entity>, ItemStack[]> entityToStacks = new HashMap<Class<? extends Entity>, ItemStack[]>();

    public ProviderEntitySpecials() {
        ItemStack minecart = new ItemStack(Items.field_151143_au);
        this.register(EntityMinecartEmpty.class, minecart);
        this.register(EntityMinecartFurnace.class, minecart, new ItemStack(Blocks.field_150460_al));
        this.register(EntityMinecartTNT.class, minecart, new ItemStack(Blocks.field_150335_W));
        this.register(EntityMinecartChest.class, minecart, new ItemStack((Block)Blocks.field_150486_ae));
        this.register(EntityMinecartHopper.class, minecart, new ItemStack((Block)Blocks.field_150438_bZ));
    }

    private void register(Class<? extends Entity> clazz, ItemStack ... stacks) {
        this.entityToStacks.put(clazz, stacks);
    }

    @Override
    public EventPriority getPriority() {
        return EventPriority.NORMAL;
    }

    @Override
    public void addIngredients(EntityContext context, IIngredientList ingredients) {
        ItemStack[] stacks = this.entityToStacks.get(context.entity.getClass());
        if (stacks != null) {
            for (ItemStack stack : stacks) {
                ingredients.addItemStack(stack);
            }
            if (context.entity instanceof EntityMinecartContainer) {
                IItemHandler handler = (IItemHandler)context.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                ProviderInventoryContents.appendItemHandler(handler, ingredients);
            }
        }
    }
}

