/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates.ingredients.providers;

import com.minemaarten.templatewands.APIHandler;
import com.minemaarten.templatewands.api.blacklist.IBlacklistProvider;
import com.minemaarten.templatewands.api.ingredients.IBlockIngredientProvider;
import com.minemaarten.templatewands.api.ingredients.IEntityIngredientProvider;
import com.minemaarten.templatewands.api.util.BlockContext;
import com.minemaarten.templatewands.api.util.EntityContext;
import com.minemaarten.templatewands.templates.ingredients.providers.IngredientList;
import java.util.List;

public class IngredientProviderManager {
    private final List<IBlockIngredientProvider> blockIngredientProviders;
    private final List<IEntityIngredientProvider> entityIngredientProviders;
    private final List<IBlacklistProvider> blacklistProviders;

    public IngredientProviderManager(APIHandler apiHandler) {
        this.blockIngredientProviders = apiHandler.blockIngredientProviders;
        this.entityIngredientProviders = apiHandler.entityIngredientProviders;
        this.blacklistProviders = apiHandler.blacklistProviders;
    }

    public EnumCaptureStatus addIngredients(BlockContext context, IngredientList ingredients) {
        if (this.isBlacklisted(context)) {
            return EnumCaptureStatus.BLACKLISTED;
        }
        ingredients.resetChanged();
        for (IBlockIngredientProvider provider : this.blockIngredientProviders) {
            provider.addIngredients(context, ingredients);
            if (!ingredients.hasChanged()) continue;
            return EnumCaptureStatus.ALLOWED;
        }
        return EnumCaptureStatus.BLACKLISTED;
    }

    public EnumCaptureStatus addIngredients(EntityContext context, IngredientList ingredients) {
        ingredients.resetChanged();
        for (IEntityIngredientProvider provider : this.entityIngredientProviders) {
            provider.addIngredients(context, ingredients);
            if (!ingredients.hasChanged()) continue;
            return EnumCaptureStatus.ALLOWED;
        }
        return EnumCaptureStatus.BLACKLISTED;
    }

    private boolean isBlacklisted(BlockContext context) {
        for (IBlacklistProvider provider : this.blacklistProviders) {
            if (!provider.shouldBlacklist(context)) continue;
            return true;
        }
        return false;
    }

    public static enum EnumCaptureStatus {
        ALLOWED,
        BLACKLISTED;

    }
}

