/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates.ingredients.providers;

import com.minemaarten.templatewands.api.ingredients.IIngredientList;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredient;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredientFluidStack;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredientItemStackExact;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class IngredientList
implements IIngredientList,
Iterable<TemplateIngredient<?>> {
    public List<TemplateIngredient<?>> ingredients = new ArrayList();
    private boolean hasChanged;

    @Override
    public void addItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Stack may not be empty!");
        }
        this.add(new TemplateIngredientItemStackExact(stack));
    }

    @Override
    public void addFluidStack(FluidStack fluid) {
        this.add(new TemplateIngredientFluidStack(fluid));
    }

    private void add(TemplateIngredient<?> ingredient) {
        this.hasChanged = true;
        for (TemplateIngredient<?> existing : this.ingredients) {
            if (existing.getClass() != ingredient.getClass() || !existing.applies(ingredient)) continue;
            existing.addAmount(ingredient.getAmount());
            return;
        }
        this.ingredients.add(ingredient);
    }

    public void resetChanged() {
        this.hasChanged = false;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void markChanged() {
        this.hasChanged = true;
    }

    public IngredientList copy() {
        IngredientList copy = new IngredientList();
        for (TemplateIngredient<?> ingredient : this.ingredients) {
            copy.ingredients.add(ingredient.copy());
        }
        return copy;
    }

    public void subtract(IngredientList other) {
        for (TemplateIngredient<?> toSubtract : other.ingredients) {
            this.subtract(toSubtract);
        }
    }

    private void subtract(TemplateIngredient<?> other) {
        Iterator<TemplateIngredient<?>> iterator = this.ingredients.iterator();
        while (iterator.hasNext()) {
            TemplateIngredient<?> ingredient = iterator.next();
            if (!ingredient.applies(other)) continue;
            if (ingredient.getAmount() > other.getAmount()) {
                ingredient.addAmount(-other.getAmount());
                break;
            }
            iterator.remove();
            break;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (TemplateIngredient<?> ingredient : this.ingredients) {
            NBTTagCompound t = new NBTTagCompound();
            ingredient.writeToNBT(t);
            tagList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("ingredients", (NBTBase)tagList);
    }

    public static IngredientList fromNBT(NBTTagCompound tag) {
        IngredientList ingredients = new IngredientList();
        NBTTagList tagList = tag.func_150295_c("ingredients", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound t = tagList.func_150305_b(i);
            ingredients.ingredients.add(TemplateIngredient.fromTag(t));
        }
        return ingredients;
    }

    @Override
    public Iterator<TemplateIngredient<?>> iterator() {
        return this.ingredients.iterator();
    }
}

