/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates.ingredients;

import com.minemaarten.templatewands.templates.ingredients.TemplateIngredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class TemplateIngredientFluidStack
extends TemplateIngredient<FluidStack> {
    public TemplateIngredientFluidStack(FluidStack stack) {
        super(stack.copy());
    }

    public TemplateIngredientFluidStack(NBTTagCompound tag) {
        this(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag));
    }

    @Override
    public boolean appliesTo(FluidStack ingredient) {
        return ((FluidStack)this.ingredient).isFluidEqual(ingredient);
    }

    @Override
    public void addAmount(int amount) {
        ((FluidStack)this.ingredient).amount += amount;
    }

    @Override
    public int getAmount() {
        return ((FluidStack)this.ingredient).amount;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        ((FluidStack)this.ingredient).writeToNBT(tag);
    }

    @Override
    protected TemplateIngredient.EnumIngredientType getIngredientType() {
        return TemplateIngredient.EnumIngredientType.FLUID_STACK;
    }

    public String toString() {
        return ((FluidStack)this.ingredient).amount + "mB " + ((FluidStack)this.ingredient).getLocalizedName();
    }
}

