/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates.ingredients;

import com.minemaarten.templatewands.templates.ingredients.TemplateIngredientFluidStack;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredientItemStack;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredientItemStackExact;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.Validate;

public abstract class TemplateIngredient<TIngredient> {
    private final Class<?> ingredientClass;
    public final TIngredient ingredient;

    public TemplateIngredient(TIngredient ingredient) {
        Validate.notNull(ingredient);
        this.ingredientClass = ingredient.getClass();
        this.ingredient = ingredient;
    }

    public boolean applies(TemplateIngredient<?> ingredient) {
        if (this.ingredientClass == ingredient.ingredientClass) {
            return this.appliesTo(ingredient.ingredient);
        }
        return false;
    }

    public abstract boolean appliesTo(TIngredient var1);

    public abstract void addAmount(int var1);

    public abstract int getAmount();

    public TemplateIngredient<?> copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return TemplateIngredient.fromTag(tag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("ingredientType", (byte)this.getIngredientType().ordinal());
    }

    protected abstract EnumIngredientType getIngredientType();

    public static TemplateIngredient<?> fromTag(NBTTagCompound tag) {
        EnumIngredientType type = EnumIngredientType.VALUES[tag.func_74771_c("ingredientType")];
        switch (type) {
            case FLUID_STACK: {
                return new TemplateIngredientFluidStack(tag);
            }
            case ITEM_STACK: {
                return new TemplateIngredientItemStack(tag);
            }
            case ITEM_STACK_EXACT: {
                return new TemplateIngredientItemStackExact(tag);
            }
        }
        throw new IllegalStateException("Unknown ingredient type: " + (Object)((Object)type));
    }

    protected static enum EnumIngredientType {
        ITEM_STACK,
        ITEM_STACK_EXACT,
        FLUID_STACK;

        private static EnumIngredientType[] VALUES;

        static {
            VALUES = EnumIngredientType.values();
        }
    }
}

