/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.minemaarten.templatewands.TemplateWands;
import com.minemaarten.templatewands.api.util.BlockContext;
import com.minemaarten.templatewands.api.util.EntityContext;
import com.minemaarten.templatewands.templates.IngredientRequirementResult;
import com.minemaarten.templatewands.templates.ingredients.providers.IngredientList;
import com.minemaarten.templatewands.templates.ingredients.providers.IngredientProviderManager;
import com.minemaarten.templatewands.util.EnumFacingUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.NotImplementedException;

public class TemplateSurvival
extends Template {
    private EnumFacing captureFacing;
    private IngredientList ingredients = new IngredientList();
    public Set<BlockPos> blacklistedPositions = new HashSet<BlockPos>();
    private BlockPos offset;

    public TemplateSurvival setCaptureFacing(EnumFacing captureFacing) {
        if (captureFacing.func_176740_k() == EnumFacing.Axis.Y) {
            throw new IllegalArgumentException("Only horizontals are allowed!");
        }
        this.captureFacing = captureFacing;
        return this;
    }

    public IngredientRequirementResult addBlocksToWorld(World world, BlockPos pos, EnumFacing facing, boolean useItems, IItemHandler handler) {
        IngredientRequirementResult result;
        IngredientRequirementResult ingredientRequirementResult = result = useItems ? new IngredientRequirementResult(handler, this.ingredients) : IngredientRequirementResult.EMPTY;
        if (result.hasAllRequiredItems()) {
            this.removeExistingBlocks(world, pos, facing, useItems);
            result.takeItems();
            this.func_186253_b(world, pos, this.getPlacementSettings(facing));
        }
        return result;
    }

    public AxisAlignedBB getAABB(BlockPos pos, EnumFacing facing) {
        PlacementSettings settings = this.getPlacementSettings(facing);
        pos = pos.func_177971_a((Vec3i)TemplateSurvival.func_186266_a((PlacementSettings)settings, (BlockPos)this.getOffset()));
        BlockPos endPos = TemplateSurvival.func_186266_a((PlacementSettings)settings, (BlockPos)this.field_186272_c.func_177982_a(-1, -1, -1)).func_177971_a((Vec3i)pos);
        return new AxisAlignedBB(pos, endPos).func_72321_a(1.0, 1.0, 1.0);
    }

    public BlockPos calculateConnectedPos(BlockPos startPos, EnumFacing facing) {
        BlockPos size = this.func_186257_a(this.getPlacementSettings(facing).func_186215_c());
        return startPos.func_177971_a((Vec3i)EnumFacingUtils.getComponent(size, facing));
    }

    private Iterable<BlockPos> getTemplatePositions(BlockPos pos, EnumFacing facing) {
        PlacementSettings settings = this.getPlacementSettings(facing);
        pos = pos.func_177971_a((Vec3i)TemplateSurvival.func_186266_a((PlacementSettings)settings, (BlockPos)this.getOffset()));
        BlockPos endPos = TemplateSurvival.func_186266_a((PlacementSettings)settings, (BlockPos)this.field_186272_c.func_177982_a(-1, -1, -1)).func_177971_a((Vec3i)pos);
        return BlockPos.func_177980_a((BlockPos)pos, (BlockPos)endPos);
    }

    private PlacementSettings getPlacementSettings(EnumFacing facing) {
        Rotation rotation = EnumFacingUtils.getRotation(this.captureFacing, facing);
        return new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(rotation).func_186222_a(false).func_186218_a(null).func_186225_a(null).func_186226_b(true);
    }

    private void removeExistingBlocks(World world, BlockPos pos, EnumFacing facing, boolean dropItems) {
        for (BlockPos p : this.getTemplatePositions(pos, facing)) {
            world.func_175655_b(p, dropItems);
        }
    }

    @Deprecated
    public void func_186254_a(World worldIn, BlockPos startPos, BlockPos endPos, boolean takeEntities, @Nullable Block toIgnore) {
        throw new NotImplementedException("Use the version using EntityPlayer");
    }

    public void takeBlocksFromWorld(World worldIn, BlockPos startPos, BlockPos endPos, boolean takeEntities, @Nullable Block toIgnore, EntityPlayer player, BlockPos origin) {
        this.ingredients = new IngredientList();
        this.blacklistedPositions.clear();
        this.offset = null;
        if (endPos.func_177958_n() >= 1 && endPos.func_177956_o() >= 1 && endPos.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)endPos).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.field_186272_c = endPos;
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos3 = blockpos$mutableblockpos.func_177973_b((Vec3i)origin);
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (toIgnore != null && toIgnore == iblockstate.func_177230_c()) continue;
                TileEntity tileentity = worldIn.func_175625_s((BlockPos)blockpos$mutableblockpos);
                if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos)) continue;
                if (!this.capture(new BlockContext((BlockPos)blockpos$mutableblockpos, iblockstate, tileentity, player))) {
                    this.blacklistedPositions.add(new BlockPos((Vec3i)blockpos$mutableblockpos));
                    continue;
                }
                if (tileentity != null) {
                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                    nbttagcompound.func_82580_o("x");
                    nbttagcompound.func_82580_o("y");
                    nbttagcompound.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos3, iblockstate, nbttagcompound));
                    continue;
                }
                if (!iblockstate.func_185913_b() && !iblockstate.func_185917_h()) {
                    list2.add(new Template.BlockInfo(blockpos3, iblockstate, (NBTTagCompound)null));
                    continue;
                }
                list.add(new Template.BlockInfo(blockpos3, iblockstate, (NBTTagCompound)null));
            }
            this.field_186270_a.clear();
            this.field_186270_a.addAll(list);
            this.field_186270_a.addAll(list1);
            this.field_186270_a.addAll(list2);
            if (takeEntities) {
                this.takeEntitiesFromWorld(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1), player, origin);
            } else {
                this.field_186271_b.clear();
            }
        }
    }

    private void takeEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos, EntityPlayer player, BlockPos origin) {
        List list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return !(p_apply_1_ instanceof EntityPlayer);
            }
        });
        this.field_186271_b.clear();
        for (Entity entity : list) {
            if (!this.capture(new EntityContext(entity, player))) continue;
            Vec3d vec3d = new Vec3d(entity.field_70165_t - (double)origin.func_177958_n(), entity.field_70163_u - (double)origin.func_177956_o(), entity.field_70161_v - (double)origin.func_177952_p());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity.func_70039_c(nbttagcompound);
            BlockPos blockpos = entity instanceof EntityPainting ? ((EntityPainting)entity).func_174857_n().func_177973_b((Vec3i)origin) : new BlockPos(vec3d);
            this.field_186271_b.add(new Template.EntityInfo(vec3d, blockpos, nbttagcompound));
        }
    }

    private boolean capture(BlockContext context) {
        return TemplateWands.instance.getProviderManager().addIngredients(context, this.ingredients) == IngredientProviderManager.EnumCaptureStatus.ALLOWED;
    }

    private boolean capture(EntityContext context) {
        return TemplateWands.instance.getProviderManager().addIngredients(context, this.ingredients) == IngredientProviderManager.EnumCaptureStatus.ALLOWED;
    }

    private BlockPos getOffset() {
        if (this.offset == null) {
            for (Template.BlockInfo info : this.field_186270_a) {
                if (this.offset == null) {
                    this.offset = info.field_186242_a;
                    continue;
                }
                this.offset = EnumFacingUtils.min(this.offset, info.field_186242_a);
            }
            if (this.offset == null) {
                this.offset = BlockPos.field_177992_a;
            }
        }
        return this.offset;
    }

    public NBTTagCompound func_189552_a(NBTTagCompound tag) {
        tag.func_74774_a("facing", (byte)this.captureFacing.ordinal());
        this.ingredients.writeToNBT(tag);
        return super.func_189552_a(tag);
    }

    public void func_186256_b(NBTTagCompound tag) {
        this.captureFacing = EnumFacing.field_82609_l[tag.func_74771_c("facing")];
        this.ingredients = IngredientList.fromNBT(tag);
        this.offset = null;
        super.func_186256_b(tag);
    }

    public void writeToBuf(ByteBuf b) {
        b.writeByte(this.captureFacing.ordinal());
        new PacketBuffer(b).func_179255_a(this.field_186272_c);
        new PacketBuffer(b).func_179255_a(this.getOffset());
    }

    public static TemplateSurvival fromByteBuf(ByteBuf b) {
        TemplateSurvival template = new TemplateSurvival();
        template.captureFacing = EnumFacing.field_82609_l[b.readByte()];
        template.field_186272_c = new PacketBuffer(b).func_179259_c();
        template.offset = new PacketBuffer(b).func_179259_c();
        return template;
    }
}

