/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates;

import com.minemaarten.templatewands.items.IAABBRenderer;
import com.minemaarten.templatewands.network.NetworkHandler;
import com.minemaarten.templatewands.network.PacketUpdateCapturing;
import com.minemaarten.templatewands.templates.TemplateSurvival;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TemplateCapturer {
    public final BlockPos firstPos;
    public BlockPos lastKnownClientPos;
    public Set<BlockPos> blacklistedPositions = Collections.emptySet();

    public TemplateCapturer(BlockPos firstPos) {
        this.firstPos = firstPos;
    }

    public TemplateSurvival capture(World world, BlockPos secondPos, EntityPlayer player) {
        BlockPos startPos = new BlockPos(Math.min(this.firstPos.func_177958_n(), secondPos.func_177958_n()), Math.min(this.firstPos.func_177956_o(), secondPos.func_177956_o()), Math.min(this.firstPos.func_177952_p(), secondPos.func_177952_p()));
        BlockPos maxPos = new BlockPos(Math.max(this.firstPos.func_177958_n(), secondPos.func_177958_n()), Math.max(this.firstPos.func_177956_o(), secondPos.func_177956_o()), Math.max(this.firstPos.func_177952_p(), secondPos.func_177952_p()));
        BlockPos size = maxPos.func_177973_b((Vec3i)startPos).func_177982_a(1, 1, 1);
        TemplateSurvival template = new TemplateSurvival();
        template.setCaptureFacing(player.func_174811_aO());
        template.takeBlocksFromWorld(world, startPos, size, true, null, player, secondPos);
        return template;
    }

    public void onInterval(World world, EntityPlayer player) {
        if (this.lastKnownClientPos != null) {
            TemplateSurvival template = this.capture(world, this.lastKnownClientPos, player);
            if (!template.blacklistedPositions.equals(this.blacklistedPositions)) {
                this.blacklistedPositions = template.blacklistedPositions;
                NetworkHandler.sendTo(new PacketUpdateCapturing(this.firstPos, this.blacklistedPositions), (EntityPlayerMP)player);
            }
        }
    }

    public void addBlacklistAABBs(Set<IAABBRenderer.ColoredAABB> aabbs) {
        for (BlockPos p : this.blacklistedPositions) {
            aabbs.add(new IAABBRenderer.ColoredAABB(new AxisAlignedBB(p), 0xFF0000));
        }
    }
}

