/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.templates;

import com.minemaarten.templatewands.templates.ingredients.TemplateIngredient;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredientFluidStack;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredientItemStack;
import com.minemaarten.templatewands.templates.ingredients.providers.IngredientList;
import com.minemaarten.templatewands.util.Log;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class IngredientRequirementResult {
    private final IItemHandler inventory;
    private final IngredientList ingredients;
    private final IngredientList missingIngredients;
    public static final IngredientRequirementResult EMPTY = new IngredientRequirementResult((IItemHandler)new ItemStackHandler(0), new IngredientList());

    public IngredientRequirementResult(IItemHandler inventory, IngredientList ingredients) {
        this.inventory = inventory;
        this.ingredients = ingredients;
        IngredientList inventoryIngredients = IngredientRequirementResult.toIngredientList(inventory);
        this.missingIngredients = ingredients.copy();
        this.missingIngredients.subtract(inventoryIngredients);
    }

    private static IngredientList toIngredientList(IItemHandler inventory) {
        IngredientList ingredients = new IngredientList();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluid != null) {
                ingredients.addFluidStack(fluid);
                continue;
            }
            ingredients.addItemStack(stack);
        }
        return ingredients;
    }

    public boolean hasAllRequiredItems() {
        return this.missingIngredients.ingredients.isEmpty();
    }

    public IngredientList getMissingIngredients() {
        return this.missingIngredients;
    }

    public void takeItems() {
        for (TemplateIngredient<?> ingredient : this.ingredients) {
            if (ingredient instanceof TemplateIngredientItemStack) {
                TemplateIngredientItemStack itemIngredient = (TemplateIngredientItemStack)ingredient;
                if (!IngredientRequirementResult.extractItems(this.inventory, itemIngredient::appliesTo, itemIngredient.getAmount())) {
                    Log.warning("Could not extract the ingredient " + ingredient + " (dupe bug!)");
                }
            }
            if (!(ingredient instanceof TemplateIngredientFluidStack)) continue;
            TemplateIngredientFluidStack fluidIngredient = (TemplateIngredientFluidStack)ingredient;
            if (IngredientRequirementResult.extractFluids(this.inventory, ((FluidStack)fluidIngredient.ingredient).getFluid(), fluidIngredient.getAmount())) continue;
            Log.warning("Could not extract the ingredient " + ingredient + " (dupe bug!)");
        }
    }

    private static boolean extractItems(IItemHandler handler, Predicate<ItemStack> matcher, int amount) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack extracted;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b() || !matcher.test(stack) || (amount -= (extracted = handler.extractItem(slot, amount, false)).func_190916_E()) > 0) continue;
            return true;
        }
        return false;
    }

    private static boolean extractFluids(IItemHandler handler, Fluid fluid, int amount) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            FluidStack toExtract;
            FluidStack extracted;
            ItemStack containerCopy;
            IFluidHandlerItem containerFluidHandler;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b() || (containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)(containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1)))) == null || (extracted = containerFluidHandler.drain(toExtract = new FluidStack(fluid, amount), true)) == null) continue;
            if (handler.extractItem(slot, stack.func_190916_E(), false).func_190916_E() != stack.func_190916_E()) {
                Log.warning("Could not extract tank item " + stack);
            }
            if (!containerFluidHandler.getContainer().func_190926_b() && !handler.insertItem(slot, containerFluidHandler.getContainer(), false).func_190926_b()) {
                Log.warning("Could not insert emtpied tank item " + containerFluidHandler.getContainer());
            }
            if ((amount -= extracted.amount) > 0) continue;
            return true;
        }
        return false;
    }
}

