/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.network;

import com.minemaarten.templatewands.capabilities.CapabilityTemplateWand;
import com.minemaarten.templatewands.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class PacketUpdateCapturing
extends AbstractPacket<PacketUpdateCapturing> {
    private BlockPos startPos;
    private Set<BlockPos> blacklistedPositions;

    public PacketUpdateCapturing(BlockPos startPos, Set<BlockPos> blacklistedPositions) {
        this.startPos = startPos;
        this.blacklistedPositions = blacklistedPositions;
    }

    public PacketUpdateCapturing() {
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer b = new PacketBuffer(buf);
        b.func_179255_a(this.startPos);
        b.writeInt(this.blacklistedPositions.size());
        for (BlockPos p : this.blacklistedPositions) {
            b.func_179255_a(p);
        }
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer b = new PacketBuffer(buf);
        this.startPos = b.func_179259_c();
        int count = b.readInt();
        this.blacklistedPositions = new HashSet<BlockPos>(count);
        for (int i = 0; i < count; ++i) {
            this.blacklistedPositions.add(b.func_179259_c());
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ItemStack heldItem = player.func_184614_ca();
        CapabilityTemplateWand cap = (CapabilityTemplateWand)heldItem.getCapability(CapabilityTemplateWand.INSTANCE, null);
        if (cap != null) {
            cap.updateCaptureState(this.startPos, this.blacklistedPositions);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

