/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.items;

import com.minemaarten.templatewands.TemplateWands;
import com.minemaarten.templatewands.capabilities.CapabilityTemplateWand;
import com.minemaarten.templatewands.capabilities.DefaultCapabilityProvider;
import com.minemaarten.templatewands.items.IAABBRenderer;
import com.minemaarten.templatewands.network.NetworkHandler;
import com.minemaarten.templatewands.network.PacketInteractInMidAir;
import com.minemaarten.templatewands.network.PacketUpdateHoveredPos;
import com.minemaarten.templatewands.templates.TemplateCapturer;
import com.minemaarten.templatewands.templates.TemplateSurvival;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTemplateWand
extends Item
implements IAABBRenderer {
    private final int maxBlocks;

    public ItemTemplateWand(int maxBlocks) {
        this.maxBlocks = maxBlocks;
        this.func_77637_a(TemplateWands.creativeTab);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new DefaultCapabilityProvider<CapabilityTemplateWand>(CapabilityTemplateWand.INSTANCE);
    }

    private CapabilityTemplateWand getCap(ItemStack stack) {
        return (CapabilityTemplateWand)stack.getCapability(CapabilityTemplateWand.INSTANCE, null);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            return this.interactWand(player, world, pos, stack, player.func_174811_aO());
        }
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult interactWand(EntityPlayer player, World world, BlockPos pos, ItemStack stack, EnumFacing facing) {
        BlockPos lockPos = this.getPlacementLockPos(stack);
        EnumFacing lockFacing = lockPos != null ? this.getPlacementLockFacing(stack) : null;
        this.clearPlacementLock(stack);
        CapabilityTemplateWand cap = this.getCap(stack);
        if (!player.func_70093_af()) {
            if (cap.hasTemplate()) {
                if (lockPos != null) {
                    pos = lockPos;
                    facing = lockFacing;
                }
                cap.place(world, pos, player, facing, this.getRepeatAmount(stack));
                return EnumActionResult.SUCCESS;
            }
            if (cap.registerCoordinate(world, pos, player, this.maxBlocks)) {
                player.func_146105_b((ITextComponent)new TextComponentString("Coordinate registered"), true);
                return EnumActionResult.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Area too big"), true);
            return EnumActionResult.FAIL;
        }
        cap.clearTemplate(player);
        player.func_146105_b((ITextComponent)new TextComponentString("Wand cleared"), true);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184614_ca());
        }
        if (worldIn.field_72995_K) {
            NetworkHandler.sendToServer(new PacketInteractInMidAir(ItemTemplateWand.getHoveredPos(), playerIn.func_174811_aO()));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184614_ca());
    }

    public void onItemRightClick(EntityPlayer player, BlockPos posInMidAir, EnumFacing facing) {
        ItemStack heldItem = player.func_184614_ca();
        this.interactWand(player, player.field_70170_p, posInMidAir, heldItem, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public static BlockPos getHoveredPos() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        RayTraceResult hoveredObj = Minecraft.func_71410_x().field_71476_x;
        if (hoveredObj != null && hoveredObj.func_178782_a() != null) {
            return hoveredObj.func_178782_a();
        }
        return ItemTemplateWand.getMidAirPos((EntityPlayer)player);
    }

    @SideOnly(value=Side.CLIENT)
    private static BlockPos getMidAirPos(EntityPlayer player) {
        float blockReachDistance = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        Vec3d eyePosition = player.func_174824_e(1.0f);
        Vec3d look = player.func_70676_i(1.0f);
        Vec3d midAirVec = eyePosition.func_72441_c(look.field_72450_a * (double)blockReachDistance, look.field_72448_b * (double)blockReachDistance, look.field_72449_c * (double)blockReachDistance);
        return new BlockPos(midAirVec);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Set<IAABBRenderer.ColoredAABB> getAABBs(ItemStack stack) {
        CapabilityTemplateWand cap = this.getCap(stack);
        TemplateSurvival template = cap.getTemplate();
        TemplateCapturer capturer = cap.getCapturer();
        if (template != null) {
            EnumFacing facing;
            BlockPos curPos = this.getPlacementLockPos(stack);
            if (curPos != null) {
                facing = this.getPlacementLockFacing(stack);
            } else {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                curPos = ItemTemplateWand.getHoveredPos();
                facing = player.func_174811_aO();
            }
            HashSet<IAABBRenderer.ColoredAABB> aabbs = new HashSet<IAABBRenderer.ColoredAABB>();
            int repeatAmount = this.getRepeatAmount(stack);
            for (int i = 0; i < repeatAmount; ++i) {
                AxisAlignedBB aabb = template.getAABB(curPos, facing);
                aabbs.add(new IAABBRenderer.ColoredAABB(aabb, 43520));
                curPos = template.calculateConnectedPos(curPos, facing);
            }
            return aabbs;
        }
        if (capturer != null) {
            AxisAlignedBB curCaptureAABB;
            HashSet<IAABBRenderer.ColoredAABB> aabbs = new HashSet<IAABBRenderer.ColoredAABB>();
            BlockPos hoveredPos = ItemTemplateWand.getHoveredPos();
            AxisAlignedBB a = curCaptureAABB = new AxisAlignedBB(hoveredPos, capturer.firstPos).func_72321_a(1.0, 1.0, 1.0);
            boolean tooBig = (int)(a.field_72336_d - a.field_72340_a) * (int)(a.field_72337_e - a.field_72338_b) * (int)(a.field_72334_f - a.field_72339_c) > this.maxBlocks;
            aabbs.add(new IAABBRenderer.ColoredAABB(curCaptureAABB, tooBig ? 0xFF0000 : 0xFFFF00));
            capturer.addBlacklistAABBs(aabbs);
            return aabbs;
        }
        return Collections.singleton(new IAABBRenderer.ColoredAABB(new AxisAlignedBB(ItemTemplateWand.getHoveredPos()), 255));
    }

    public String getToBeRenderedText(ItemStack stack) {
        CapabilityTemplateWand cap = this.getCap(stack);
        TemplateSurvival template = cap.getTemplate();
        TemplateCapturer capturer = cap.getCapturer();
        if (template != null) {
            return TextFormatting.GREEN + "Right click to place, sneak right click to clear";
        }
        if (capturer != null) {
            AxisAlignedBB curCaptureAABB;
            BlockPos hoveredPos = ItemTemplateWand.getHoveredPos();
            AxisAlignedBB a = curCaptureAABB = new AxisAlignedBB(hoveredPos, capturer.firstPos).func_72321_a(1.0, 1.0, 1.0);
            int blocks = (int)(a.field_72336_d - a.field_72340_a) * (int)(a.field_72337_e - a.field_72338_b) * (int)(a.field_72334_f - a.field_72339_c);
            return (blocks > this.maxBlocks ? TextFormatting.RED : TextFormatting.YELLOW) + "Right click to finish. Blocks: " + blocks + "/" + (this.maxBlocks == Integer.MAX_VALUE ? "-" : Integer.valueOf(this.maxBlocks));
        }
        return TextFormatting.BLUE + "Right click to start capturing area";
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L && entity instanceof EntityPlayer) {
            this.getCap(stack).onInterval(world, (EntityPlayer)entity);
        }
        if (world.field_72995_K && this.getCap(stack).getCapturer() != null) {
            NetworkHandler.sendToServer(new PacketUpdateHoveredPos(ItemTemplateWand.getHoveredPos()));
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("Max blocks: " + (this.maxBlocks == Integer.MAX_VALUE ? "Unlimited" : Integer.valueOf(this.maxBlocks)));
        tooltip.add("While holding:");
        tooltip.add("Press [+] to increase repeat placement");
        tooltip.add("Press [-] to decrease repeat placement");
        tooltip.add("Press [L] to (un)lock the placement position");
    }

    private int getRepeatAmount(ItemStack stack) {
        NBTTagCompound tag = stack.func_190925_c("wand");
        if (tag.func_74764_b("repeatAmount")) {
            return tag.func_74762_e("repeatAmount");
        }
        return 1;
    }

    private void setRepeatAmount(EntityPlayer player, ItemStack stack, int amount) {
        stack.func_190925_c("wand").func_74768_a("repeatAmount", amount);
        player.func_146105_b((ITextComponent)new TextComponentString("Repeating: x" + amount), true);
    }

    public void incRepeatAmount(EntityPlayer player, ItemStack stack) {
        this.setRepeatAmount(player, stack, this.getRepeatAmount(stack) + 1);
    }

    public void decRepeatAmount(EntityPlayer player, ItemStack stack) {
        int repeatAmount = this.getRepeatAmount(stack);
        if (repeatAmount > 1) {
            this.setRepeatAmount(player, stack, repeatAmount - 1);
        }
    }

    public void togglePlacementLock(EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing facing) {
        CapabilityTemplateWand cap = this.getCap(stack);
        TemplateSurvival template = cap.getTemplate();
        if (template == null) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "First set a template."), true);
        } else if (this.getPlacementLockPos(stack) == null) {
            this.setPlacementLock(stack, pos, facing);
        } else {
            this.clearPlacementLock(stack);
        }
    }

    private void clearPlacementLock(ItemStack stack) {
        this.setPlacementLock(stack, null, null);
    }

    private void setPlacementLock(ItemStack stack, BlockPos pos, EnumFacing facing) {
        NBTTagCompound tag = stack.func_190925_c("wand");
        tag.func_74757_a("locked", pos != null);
        if (pos != null) {
            tag.func_74768_a("x", pos.func_177958_n());
            tag.func_74768_a("y", pos.func_177956_o());
            tag.func_74768_a("z", pos.func_177952_p());
            tag.func_74774_a("facing", (byte)facing.ordinal());
        }
    }

    private BlockPos getPlacementLockPos(ItemStack stack) {
        NBTTagCompound tag = stack.func_190925_c("wand");
        if (tag.func_74767_n("locked")) {
            return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        }
        return null;
    }

    private EnumFacing getPlacementLockFacing(ItemStack stack) {
        byte b = stack.func_190925_c("wand").func_74771_c("facing");
        return EnumFacing.field_82609_l[b];
    }
}

